/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps.engine;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.Notifier;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;

public final class StepResponseUtil {
    private StepResponseUtil() {
    }

    public static void sendResponse(State state) {
        assert (ThreadUtil.isRunningOnPartitionThread());
        MapOperation operation = state.getOperation();
        operation.applyState(state);
        StepResponseUtil.handleBackupAndSendResponse(state);
        try {
            Notifier notifier;
            if (operation instanceof Notifier && (notifier = (Notifier)((Object)operation)).shouldNotify()) {
                StepResponseUtil.getNodeEngine(state).getOperationParker().unpark(notifier);
            }
        }
        catch (Throwable e) {
            StepResponseUtil.logOperationError(operation, e);
        }
    }

    private static NodeEngineImpl getNodeEngine(State state) {
        return (NodeEngineImpl)state.getRecordStore().getMapContainer().getMapServiceContext().getNodeEngine();
    }

    private static void logOperationError(Operation op, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryError error = (OutOfMemoryError)e;
            OutOfMemoryErrorDispatcher.onOutOfMemory(error);
        }
        op.logError(e);
    }

    private static void handleBackupAndSendResponse(State state) {
        assert (state.getPartitionId() != -1);
        OperationRunner runner = StepResponseUtil.getOperationService(state).getOperationExecutor().getPartitionOperationRunners()[state.getPartitionId()];
        ((OperationRunnerImpl)runner).sendBackupsAndResponse(state.getOperation());
    }

    private static OperationService getOperationService(State state) {
        MapContainer mapContainer = state.getOperation().getMapContainer();
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        return mapServiceContext.getNodeEngine().getOperationService();
    }
}

