/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.Offloadable;
import com.hazelcast.core.ReadOnly;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.ExecutorStats;
import com.hazelcast.map.impl.operation.EntryBackupOperation;
import com.hazelcast.map.impl.operation.EntryOffloadableLockMismatchException;
import com.hazelcast.map.impl.operation.EntryOffloadableSetUnlockOperation;
import com.hazelcast.map.impl.operation.EntryOperator;
import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.map.impl.operation.steps.EntryOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.recordstore.StaticParams;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.executionservice.impl.StatsAwareRunnable;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.BlockingOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationAccessor;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandler;
import com.hazelcast.spi.impl.operationservice.SelfResponseOperation;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.wan.impl.CallerProvenance;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class EntryOperation
extends LockAwareOperation
implements BackupAwareOperation,
BlockingOperation,
MutatingOperation,
SelfResponseOperation {
    private static final int SET_UNLOCK_FAST_RETRY_LIMIT = 10;
    private EntryProcessor entryProcessor;
    private transient boolean offload;
    private transient Object response;
    private transient boolean readOnly;
    private transient int setUnlockRetryCount;
    private transient long begin;

    public EntryOperation() {
    }

    public EntryOperation(String name, Data dataKey, EntryProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        this.begin = Clock.currentTimeMillis();
        this.readOnly = this.entryProcessor instanceof ReadOnly;
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        this.entryProcessor = (EntryProcessor)managedContext.initialize(this.entryProcessor);
        if (this.readOnly && this.existInMemory(this.dataKey)) {
            this.mapStoreOffloadEnabled = false;
            this.tieredStoreOffloadEnabled = false;
        } else {
            this.mapStoreOffloadEnabled = this.isMapStoreOffloadEnabled();
            this.tieredStoreOffloadEnabled = this.isTieredStoreOffloadEnabled();
        }
    }

    private boolean existInMemory(Data dataKey) {
        if (!this.tieredStoreOffloadEnabled) {
            return this.recordStore.existInMemory(dataKey);
        }
        int threadIndex = this.recordStore.beforeOperation();
        if (this.recordStore.existInMemory(dataKey)) {
            return true;
        }
        this.recordStore.afterOperation(threadIndex);
        return false;
    }

    @Override
    public CallStatus call() {
        if (this.shouldWait()) {
            return CallStatus.WAIT;
        }
        boolean bl = this.disposeDeferredBlocks = !this.offload;
        if (this.steppedOperationOffloadEnabled()) {
            assert (this.recordStore != null);
            return this.offloadOperation();
        }
        if (this.offload) {
            Object oldValue = this.recordStore.get(this.dataKey, false, this.getCallerAddress());
            return new EntryOperationOffload(oldValue);
        }
        this.response = EntryOperator.operator(this, this.entryProcessor).operateOnKey(this.dataKey).doPostOperateOps().getResult();
        return CallStatus.RESPONSE;
    }

    private boolean steppedOperationOffloadEnabled() {
        return this.mapStoreOffloadEnabled || this.tieredStoreOffloadEnabled;
    }

    @Override
    public State createState() {
        return super.createState().setKey(this.dataKey).setCallerProvenance(CallerProvenance.NOT_WAN).setEntryProcessor(this.entryProcessor).setEntryProcessorOffloadable(this.offload).setStaticPutParams(StaticParams.SET_WITH_NO_ACCESS_PARAMS);
    }

    @Override
    public Step getStartingStep() {
        return EntryOpSteps.EP_START;
    }

    @Override
    public void applyState(State state) {
        this.response = state.getOperator().getResult();
    }

    @Override
    protected void runInternal() {
    }

    @Override
    public boolean shouldWait() {
        if (this.entryProcessor instanceof ReadOnly) {
            this.offload = this.isOffloadingRequested(this.entryProcessor);
            return false;
        }
        if (!this.recordStore.isLocked(this.dataKey) && this.isOffloadingRequested(this.entryProcessor)) {
            this.offload = true;
            return false;
        }
        this.offload = false;
        return super.shouldWait();
    }

    private boolean isOffloadingRequested(EntryProcessor entryProcessor) {
        if (entryProcessor instanceof Offloadable) {
            Offloadable offloadable = (Offloadable)((Object)entryProcessor);
            String executorName = offloadable.getExecutorName();
            return !executorName.equals("no-offloading");
        }
        return false;
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }

    @Override
    public Object getResponse() {
        if (this.offload && !this.steppedOperationOffloadEnabled()) {
            return null;
        }
        return this.response;
    }

    @Override
    public boolean returnsResponse() {
        if (this.offload && !this.steppedOperationOffloadEnabled()) {
            return false;
        }
        return super.returnsResponse();
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.offload && !this.steppedOperationOffloadEnabled()) {
            this.sendResponse(e);
        } else {
            super.onExecutionFailure(e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="backupProcessor can indeed be null so check is not redundant")
    public Operation getBackupOperation() {
        if (this.offload && !this.steppedOperationOffloadEnabled()) {
            return null;
        }
        EntryProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new EntryBackupOperation(this.name, this.dataKey, backupProcessor) : null;
    }

    @Override
    public boolean shouldBackup() {
        if (this.offload && !this.steppedOperationOffloadEnabled()) {
            return false;
        }
        return this.mapContainer.getTotalBackupCount() > 0 && this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public int getClassId() {
        return 20;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = this.callWithNamespaceAwareness(in::readObject);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Nullable
    public Object copyOldValueToHeapWhenNeeded(Object oldValue) {
        assert (ThreadUtil.isRunningOnPartitionThread());
        if (oldValue instanceof HeapData) {
            return oldValue;
        }
        InMemoryFormat inMemoryFormat = this.mapContainer.getMapConfig().getInMemoryFormat();
        switch (inMemoryFormat) {
            case NATIVE: {
                return oldValue instanceof Data ? ToHeapDataConverter.toHeapData((Data)oldValue) : oldValue;
            }
            case OBJECT: {
                return this.getNodeEngine().getSerializationService().toData(oldValue);
            }
            case BINARY: {
                return oldValue;
            }
        }
        throw new IllegalArgumentException("Unknown in memory format: " + String.valueOf((Object)inMemoryFormat));
    }

    public final class EntryOperationOffload
    extends Offload {
        private final Object oldValue;

        public EntryOperationOffload(Object oldValue) {
            super(EntryOperation.this);
            this.oldValue = EntryOperation.this.copyOldValueToHeapWhenNeeded(oldValue);
        }

        @Override
        public void start() {
            this.verifyEntryProcessor();
            String executorName = ((Offloadable)((Object)EntryOperation.this.entryProcessor)).getExecutorName();
            String string = executorName = executorName.equals("hz:offloadable") ? "hz:offloadable" : executorName;
            if (EntryOperation.this.readOnly) {
                this.executeReadOnlyEntryProcessor(this.oldValue, executorName);
            } else {
                this.executeMutatingEntryProcessor(this.oldValue, executorName);
            }
        }

        private void verifyEntryProcessor() {
            if (!(EntryOperation.this.entryProcessor instanceof Offloadable)) {
                throw new HazelcastException("EntryProcessor is expected to implement Offloadable for this operation");
            }
            if (EntryOperation.this.readOnly && EntryOperation.this.entryProcessor.getBackupProcessor() != null) {
                throw new HazelcastException("EntryProcessor.getBackupProcessor() should return null if ReadOnly implemented");
            }
        }

        private void executeReadOnlyEntryProcessor(Object oldValue, String executorName) {
            this.doExecute(executorName, () -> {
                try {
                    Data result = EntryOperator.operator(EntryOperation.this, EntryOperation.this.entryProcessor).operateOnKeyValue(EntryOperation.this.dataKey, oldValue).getResult();
                    EntryOperation.this.sendResponse(result);
                }
                catch (Throwable t) {
                    EntryOperation.this.sendResponse(t);
                }
            });
        }

        private void executeMutatingEntryProcessor(Object oldValue, String executorName) {
            UUID finalCaller = UuidUtil.newUnsecureUUID();
            Data finalDataKey = EntryOperation.this.dataKey;
            long finalThreadId = EntryOperation.this.threadId;
            long finalCallId = EntryOperation.this.getCallId();
            long finalBegin = EntryOperation.this.begin;
            this.lock(finalDataKey, finalCaller, finalThreadId, finalCallId);
            try {
                this.doExecute(executorName, () -> {
                    try {
                        EntryOperator entryOperator = EntryOperator.operator(EntryOperation.this, EntryOperation.this.entryProcessor).operateOnKeyValue(EntryOperation.this.dataKey, oldValue);
                        Data result = entryOperator.getResult();
                        EntryEventType modificationType = entryOperator.getEventType();
                        if (modificationType != null) {
                            long newTtl = entryOperator.getEntry().getNewTtl();
                            boolean changeExpiryOnUpdate = entryOperator.getEntry().isChangeExpiryOnUpdate();
                            Object newValue = this.serializationService.toData(entryOperator.getByPreferringDataNewValue());
                            this.updateAndUnlock((Data)this.serializationService.toData(oldValue), (Data)newValue, modificationType, changeExpiryOnUpdate, newTtl, finalCaller, finalThreadId, result, finalBegin);
                        } else {
                            this.unlockOnly(result, finalCaller, finalThreadId, finalBegin);
                        }
                    }
                    catch (Throwable t) {
                        EntryOperation.this.getLogger().severe("Unexpected error on Offloadable execution", t);
                        this.unlockOnly(t, finalCaller, finalThreadId, finalBegin);
                    }
                });
            }
            catch (Throwable t) {
                this.unlock(finalDataKey, finalCaller, finalThreadId, finalCallId, t);
                ExceptionUtil.sneakyThrow(t);
            }
        }

        private void doExecute(String executorName, Runnable runnable) {
            boolean statisticsEnabled = EntryOperation.this.mapContainer.getMapConfig().isStatisticsEnabled();
            ExecutorStats executorStats = EntryOperation.this.mapServiceContext.getOffloadedEntryProcessorExecutorStats();
            try {
                Runnable command = statisticsEnabled ? new StatsAwareRunnable(runnable, executorName, executorStats) : runnable;
                this.executionService.execute(executorName, () -> NamespaceUtil.runWithNamespace(this.nodeEngine, EntryOperation.this.mapContainer.getMapConfig().getUserCodeNamespace(), command));
            }
            catch (RejectedExecutionException e) {
                if (statisticsEnabled) {
                    executorStats.rejectExecution(executorName);
                }
                throw e;
            }
        }

        private void lock(Data finalDataKey, UUID finalCaller, long finalThreadId, long finalCallId) {
            boolean locked = EntryOperation.this.recordStore.localLock(finalDataKey, finalCaller, finalThreadId, finalCallId, -1L);
            if (!locked) {
                throw new IllegalStateException(String.format("Could not obtain a lock by the caller=%s and threadId=%d", finalCaller, EntryOperation.this.threadId));
            }
        }

        private void unlock(Data finalDataKey, UUID finalCaller, long finalThreadId, long finalCallId, Throwable cause) {
            boolean unlocked = EntryOperation.this.recordStore.unlock(finalDataKey, finalCaller, finalThreadId, finalCallId);
            if (!unlocked) {
                throw new IllegalStateException(String.format("Could not unlock by the caller=%s and threadId=%d", finalCaller, EntryOperation.this.threadId), cause);
            }
        }

        private void unlockOnly(Object result, UUID caller, long threadId, long now) {
            this.updateAndUnlock(null, null, null, true, -1L, caller, threadId, result, now);
        }

        private void updateAndUnlock(Data previousValue, Data newValue, EntryEventType modificationType, boolean changeExpiryOnUpdate, long newTtl, UUID caller, long threadId, final Object result, long now) {
            EntryOffloadableSetUnlockOperation updateOperation = new EntryOffloadableSetUnlockOperation(EntryOperation.this.name, modificationType, changeExpiryOnUpdate, newTtl, EntryOperation.this.dataKey, previousValue, newValue, caller, threadId, now, EntryOperation.this.entryProcessor.getBackupProcessor());
            updateOperation.setPartitionId(EntryOperation.this.getPartitionId());
            updateOperation.setReplicaIndex(0);
            updateOperation.setNodeEngine(this.nodeEngine);
            updateOperation.setCallerUuid(EntryOperation.this.getCallerUuid());
            OperationAccessor.setCallerAddress(updateOperation, EntryOperation.this.getCallerAddress());
            OperationResponseHandler setUnlockResponseHandler = new OperationResponseHandler(){

                public void sendResponse(Operation op, Object response) {
                    if (EntryOperationOffload.this.isRetryable(response) || EntryOperationOffload.this.isTimeout(response)) {
                        this.retry(op);
                    } else {
                        EntryOperation.this.sendResponse(this.toResponse(response));
                    }
                }

                private void retry(Operation op) {
                    ++EntryOperation.this.setUnlockRetryCount;
                    if (EntryOperationOffload.this.isFastRetryLimitReached()) {
                        EntryOperationOffload.this.executionService.schedule(() -> EntryOperationOffload.this.operationService.execute(op), 500L, TimeUnit.MILLISECONDS);
                    } else {
                        EntryOperationOffload.this.operationService.execute(op);
                    }
                }

                private Object toResponse(Object response) {
                    if (response instanceof Throwable) {
                        Throwable t = (Throwable)response;
                        if (t instanceof EntryOffloadableLockMismatchException) {
                            t = new RetryableHazelcastException(t.getMessage(), t);
                        }
                        return t;
                    }
                    return result;
                }
            };
            updateOperation.setOperationResponseHandler(setUnlockResponseHandler);
            this.operationService.execute(updateOperation);
        }

        private boolean isRetryable(Object response) {
            return response instanceof RetryableHazelcastException && !(response instanceof WrongTargetException);
        }

        private boolean isTimeout(Object response) {
            return response instanceof CallTimeoutResponse;
        }

        private boolean isFastRetryLimitReached() {
            return EntryOperation.this.setUnlockRetryCount > 10;
        }
    }
}

