/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapMergeRunnable;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.spi.impl.merge.AbstractSplitBrainHandlerService;
import com.hazelcast.spi.merge.DiscardMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

class MapSplitBrainHandlerService
extends AbstractSplitBrainHandlerService<RecordStore> {
    private final MapServiceContext mapServiceContext;
    private final ILogger logger;

    MapSplitBrainHandlerService(MapServiceContext mapServiceContext) {
        super(mapServiceContext.getNodeEngine());
        this.mapServiceContext = mapServiceContext;
        this.logger = mapServiceContext.getNodeEngine().getLogger(this.getClass());
    }

    @Override
    protected Runnable newMergeRunnable(Collection<RecordStore> mergingStores) {
        return new MapMergeRunnable(mergingStores, this, this.mapServiceContext);
    }

    @Override
    protected Iterator<RecordStore> storeIterator(int partitionId) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        Collection<RecordStore> recordStores = partitionContainer.getAllRecordStores();
        return recordStores.iterator();
    }

    @Override
    protected void onStoreCollection(RecordStore recordStore) {
        IndexRegistry partitionedIndexRegistry;
        ThreadUtil.assertRunningOnPartitionThread();
        MapSplitBrainHandlerService.resetMapDataStore(recordStore);
        MapSplitBrainHandlerService.destroyPartitionedIndexes(recordStore);
        MapContainer mapContainer = recordStore.getMapContainer();
        if (this.mapServiceContext.removeMapContainer(mapContainer) && mapContainer.shouldUseGlobalIndex()) {
            this.addIndexConfigToNewMapContainer(mapContainer.getName(), -1, mapContainer.getGlobalIndexRegistry());
        }
        if (!mapContainer.shouldUseGlobalIndex() && (partitionedIndexRegistry = mapContainer.getOrNullPartitionedIndexRegistry(recordStore.getPartitionId())) != null) {
            this.addIndexConfigToNewMapContainer(mapContainer.getName(), recordStore.getPartitionId(), partitionedIndexRegistry);
        }
    }

    private static void resetMapDataStore(RecordStore recordStore) {
        DefaultRecordStore defaultRecordStore = (DefaultRecordStore)recordStore;
        defaultRecordStore.getMapDataStore().reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyPartitionedIndexes(RecordStore recordStore) {
        MapContainer mapContainer = recordStore.getMapContainer();
        recordStore.beforeOperation();
        try {
            IndexRegistry partitionedIndexRegistry = mapContainer.getOrNullPartitionedIndexRegistry(recordStore.getPartitionId());
            if (partitionedIndexRegistry != null) {
                InternalIndex[] indexes = partitionedIndexRegistry.getIndexes();
                for (int i = 0; i < indexes.length; ++i) {
                    indexes[i].destroy();
                }
            }
        }
        finally {
            recordStore.afterOperation();
        }
    }

    private void addIndexConfigToNewMapContainer(String mapName, int partitionId, IndexRegistry indexRegistry) {
        if (indexRegistry == null) {
            return;
        }
        LinkedList<IndexConfig> indexConfigs = new LinkedList<IndexConfig>();
        InternalIndex[] internalIndexes = indexRegistry.getIndexes();
        for (int i = 0; i < internalIndexes.length; ++i) {
            indexConfigs.add(internalIndexes[i].getConfig());
        }
        MapContainer newMapContainer = this.mapServiceContext.getMapContainer(mapName);
        for (IndexConfig indexConfig : indexConfigs) {
            newMapContainer.getOrCreateIndexRegistry(partitionId).recordIndexDefinition(indexConfig);
        }
    }

    @Override
    protected void destroyStore(RecordStore store) {
        ThreadUtil.assertRunningOnPartitionThread();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Destroyed store [mapName:%s, partitionId:%d, partitionSize:%d]", store.getName(), store.getPartitionId(), store.size());
        }
        store.beforeOperation();
        try {
            if (store.getMapContainer().getMapConfig().getTieredStoreConfig().isEnabled()) {
                ((DefaultRecordStore)store).destroyStorageImmediate(false, true, null);
            } else {
                ((DefaultRecordStore)store).destroyStorageAfterClear(false, true, null);
            }
        }
        finally {
            store.afterOperation();
        }
    }

    @Override
    protected boolean hasEntries(RecordStore store) {
        ThreadUtil.assertRunningOnPartitionThread();
        return !store.isEmpty();
    }

    @Override
    protected boolean hasMergeablePolicy(RecordStore store) {
        MapConfig mapConfig = store.getMapContainer().getMapConfig();
        String policy = mapConfig.getMergePolicyConfig().getPolicy();
        String namespace = mapConfig.getUserCodeNamespace();
        SplitBrainMergePolicy mergePolicy = this.mapServiceContext.getNodeEngine().getSplitBrainMergePolicyProvider().getMergePolicy(policy, namespace);
        return !(mergePolicy instanceof DiscardMergePolicy);
    }
}

