/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.ClusterTopologyIntentTracker;
import com.hazelcast.internal.util.HostnameUtil;
import com.hazelcast.kubernetes.HazelcastKubernetesDiscoveryStrategy;
import com.hazelcast.kubernetes.KubernetesClient;
import com.hazelcast.kubernetes.KubernetesConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;

class KubernetesApiEndpointResolver
extends HazelcastKubernetesDiscoveryStrategy.EndpointResolver {
    private final String serviceName;
    private final String serviceLabel;
    private final String serviceLabelValue;
    private final String podLabel;
    private final String podLabelValue;
    private final Boolean resolveNotReadyAddresses;
    private final int port;
    private final KubernetesClient client;

    KubernetesApiEndpointResolver(ILogger logger, KubernetesConfig config, ClusterTopologyIntentTracker tracker) {
        this(logger, config.getServiceName(), config.getServicePort(), config.getServiceLabelName(), config.getServiceLabelValue(), config.getPodLabelName(), config.getPodLabelValue(), config.isResolveNotReadyAddresses(), new KubernetesClient(config, tracker));
    }

    KubernetesApiEndpointResolver(ILogger logger, String serviceName, int port, String serviceLabel, String serviceLabelValue, String podLabel, String podLabelValue, Boolean resolveNotReadyAddresses, KubernetesClient client) {
        super(logger);
        this.serviceName = serviceName;
        this.port = port;
        this.serviceLabel = serviceLabel;
        this.serviceLabelValue = serviceLabelValue;
        this.podLabel = podLabel;
        this.podLabelValue = podLabelValue;
        this.resolveNotReadyAddresses = resolveNotReadyAddresses;
        this.client = client;
    }

    @Override
    List<DiscoveryNode> resolveNodes() {
        if (this.serviceName != null && !this.serviceName.isEmpty()) {
            this.logger.fine("Using service name to discover nodes.");
            return this.getSimpleDiscoveryNodes(this.client.endpointsByName(this.serviceName));
        }
        if (this.serviceLabel != null && !this.serviceLabel.isEmpty()) {
            this.logger.fine("Using service label to discover nodes.");
            return this.getSimpleDiscoveryNodes(this.client.endpointsByServiceLabel(this.serviceLabel, this.serviceLabelValue));
        }
        if (this.podLabel != null && !this.podLabel.isEmpty()) {
            this.logger.fine("Using pod label to discover nodes.");
            return this.getSimpleDiscoveryNodes(this.client.endpointsByPodLabel(this.podLabel, this.podLabelValue));
        }
        return this.getSimpleDiscoveryNodes(this.client.endpoints());
    }

    private List<DiscoveryNode> getSimpleDiscoveryNodes(List<KubernetesClient.Endpoint> endpoints) {
        ArrayList<DiscoveryNode> discoveredNodes = new ArrayList<DiscoveryNode>();
        for (KubernetesClient.Endpoint address : endpoints) {
            this.addAddress(discoveredNodes, address);
        }
        return discoveredNodes;
    }

    private void addAddress(List<DiscoveryNode> discoveredNodes, KubernetesClient.Endpoint endpoint) {
        if (Boolean.TRUE.equals(this.resolveNotReadyAddresses) || endpoint.isReady()) {
            Address privateAddress = this.createAddress(endpoint.getPrivateAddress(), this::port);
            Address publicAddress = this.createAddress(endpoint.getPublicAddress(), this::portPublic);
            discoveredNodes.add(new SimpleDiscoveryNode(privateAddress, publicAddress, endpoint.getAdditionalProperties()));
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Found node service with addresses (private, public): %s, %s ", privateAddress, publicAddress);
            }
        }
    }

    private Address createAddress(KubernetesClient.EndpointAddress address, ToIntFunction<KubernetesClient.EndpointAddress> portResolver) {
        if (address == null) {
            return null;
        }
        String ip = address.getIp();
        InetAddress inetAddress = this.mapAddress(ip);
        int port = portResolver.applyAsInt(address);
        return new Address(inetAddress, port);
    }

    private int port(KubernetesClient.EndpointAddress address) {
        if (this.port > 0) {
            return this.port;
        }
        if (address.getPort() != null) {
            return address.getPort();
        }
        return 5701;
    }

    private int portPublic(KubernetesClient.EndpointAddress address) {
        if (address.getPort() != null) {
            return address.getPort();
        }
        if (this.port > 0) {
            return this.port;
        }
        return 5701;
    }

    @Override
    String resolveCurrentZone() {
        try {
            String zone = this.client.zone(this.podName());
            if (zone != null) {
                this.logger.info(String.format("Kubernetes plugin discovered availability zone: %s", zone));
                return zone;
            }
        }
        catch (Exception e) {
            this.logger.finest(e);
        }
        this.logger.info("Cannot fetch the current zone, ZONE_AWARE feature is disabled");
        return "unknown";
    }

    @Override
    String resolveCurrentNodeName() {
        try {
            String nodeName = this.client.nodeName(this.podName());
            if (nodeName != null) {
                this.logger.info(String.format("Kubernetes plugin discovered node name: %s", nodeName));
                return nodeName;
            }
        }
        catch (Exception e) {
            this.logger.finest(e);
        }
        this.logger.warning("Cannot fetch name of the node, NODE_AWARE feature is disabled");
        return "unknown";
    }

    private String podName() {
        String podName = System.getenv("POD_NAME");
        if (podName == null) {
            podName = HostnameUtil.getLocalHostname();
        }
        return podName;
    }

    @Override
    void start() {
        this.client.start();
    }

    @Override
    void destroy() {
        this.client.destroy();
    }
}

