/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.json;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonFactory;
import com.hazelcast.shaded.com.fasterxml.jackson.core.TSFBuilder;
import com.hazelcast.shaded.com.fasterxml.jackson.core.json.JsonReadFeature;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.annotationsupport.JacksonAnnotationExtension;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JsonUtil {
    private static final JSON JSON_JR;

    private JsonUtil() {
    }

    @Nonnull
    public static HazelcastJsonValue hazelcastJsonValue(@Nonnull Object object) {
        return new HazelcastJsonValue(object.toString());
    }

    @Nullable
    public static <T> T beanFrom(@Nonnull String jsonString, @Nonnull Class<T> type) throws IOException {
        return JSON_JR.beanFrom(type, jsonString);
    }

    @Nullable
    public static Map<String, Object> mapFrom(@Nonnull Object object) throws IOException {
        return JSON_JR.mapFrom(object);
    }

    @Nullable
    public static <T> List<T> listFrom(@Nonnull String jsonString, @Nonnull Class<T> type) throws IOException {
        return JSON_JR.listOfFrom(type, jsonString);
    }

    @Nullable
    public static List<Object> listFrom(@Nonnull String jsonString) throws IOException {
        return JSON_JR.listFrom(jsonString);
    }

    @Nullable
    public static Object anyFrom(@Nonnull String jsonString) throws IOException {
        return JSON_JR.anyFrom(jsonString);
    }

    @Nonnull
    public static <T> Iterator<T> beanSequenceFrom(@Nonnull Reader reader, @Nonnull Class<T> type) throws IOException {
        return JSON_JR.beanSequenceFrom(type, reader);
    }

    @Nonnull
    public static Iterator<Map<String, Object>> mapSequenceFrom(@Nonnull Reader reader) throws IOException {
        return JSON_JR.anySequenceFrom(reader);
    }

    @Nonnull
    public static <T> Stream<T> beanSequenceFrom(Path path, @Nonnull Class<T> type) throws IOException {
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(JsonUtil.beanSequenceFrom(reader, type), 272);
        return StreamSupport.stream(spliterator, false);
    }

    @Nonnull
    public static Stream<Map<String, Object>> mapSequenceFrom(Path path) throws IOException {
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);
        Spliterator<Map<String, Object>> spliterator = Spliterators.spliteratorUnknownSize(JsonUtil.mapSequenceFrom(reader), 272);
        return StreamSupport.stream(spliterator, false);
    }

    @Nonnull
    public static String toJson(@Nonnull Object object) throws IOException {
        return JSON_JR.asString(object);
    }

    static {
        Object jf = ((TSFBuilder)((TSFBuilder)JsonFactory.builder().enable(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)).enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS)).build();
        JSON.Builder builder = JSON.builder(jf).enable(JSON.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        try {
            Class.forName("com.fasterxml.jackson.annotation.JacksonAnnotation", false, JsonUtil.class.getClassLoader());
            builder.register(JacksonAnnotationExtension.std);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JSON_JR = builder.build();
    }
}

