/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.WrappingProcessorSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class WrappingProcessorMetaSupplier
implements ProcessorMetaSupplier,
IdentifiedDataSerializable {
    private static final long serialVersionUID = 1L;
    private ProcessorMetaSupplier wrapped;
    private FunctionEx<Processor, Processor> wrapperSupplier;

    public WrappingProcessorMetaSupplier() {
    }

    public WrappingProcessorMetaSupplier(ProcessorMetaSupplier wrapped, FunctionEx<Processor, Processor> wrapperSupplier) {
        this.wrapped = wrapped;
        this.wrapperSupplier = wrapperSupplier;
    }

    @Override
    public int preferredLocalParallelism() {
        return this.wrapped.preferredLocalParallelism();
    }

    @Nonnull
    public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        Function<? super Address, ? extends ProcessorSupplier> function = this.wrapped.get(addresses);
        return address -> new WrappingProcessorSupplier((ProcessorSupplier)function.apply((Address)address), this.wrapperSupplier);
    }

    @Override
    public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
        this.wrapped.init(context);
    }

    @Override
    @Nonnull
    public Map<String, String> getTags() {
        return this.wrapped.getTags();
    }

    @Override
    public void close(@Nullable Throwable error) throws Exception {
        this.wrapped.close(error);
    }

    @Override
    public Permission getRequiredPermission() {
        return this.wrapped.getRequiredPermission();
    }

    @Override
    public boolean isReusable() {
        return this.wrapped.isReusable();
    }

    @Override
    public boolean initIsCooperative() {
        return this.wrapped.initIsCooperative();
    }

    @Override
    public boolean closeIsCooperative() {
        return this.wrapped.closeIsCooperative();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.wrapped);
        out.writeObject(this.wrapperSupplier);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.wrapped = (ProcessorMetaSupplier)in.readObject();
        this.wrapperSupplier = (FunctionEx)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 49;
    }

    public ProcessorMetaSupplier getWrapped() {
        return this.wrapped;
    }
}

