/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.processor.ProcessorWrapper;
import com.hazelcast.logging.ILogger;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class PeekWrappedP<T>
extends ProcessorWrapper {
    private final FunctionEx<? super T, ? extends CharSequence> toStringFn;
    private final Predicate<? super T> shouldLogFn;
    private final LoggingInbox loggingInbox;
    private ILogger logger;
    private final boolean peekInput;
    private final boolean peekOutput;
    private final boolean peekSnapshot;
    private boolean peekedWatermarkLogged;

    public PeekWrappedP(@Nonnull Processor wrapped, @Nonnull FunctionEx<? super T, ? extends CharSequence> toStringFn, @Nonnull Predicate<? super T> shouldLogFn, boolean peekInput, boolean peekOutput, boolean peekSnapshot) {
        super(wrapped);
        this.toStringFn = toStringFn;
        this.shouldLogFn = shouldLogFn;
        this.peekInput = peekInput;
        this.peekOutput = peekOutput;
        this.peekSnapshot = peekSnapshot;
        this.loggingInbox = peekInput ? new LoggingInbox() : null;
    }

    @Override
    protected Outbox wrapOutbox(Outbox outbox) {
        return new LoggingOutbox(outbox, this.peekOutput, this.peekSnapshot);
    }

    @Override
    protected void initWrapper(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.logger = context.logger();
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        if (this.peekInput) {
            this.loggingInbox.wrappedInbox = inbox;
            this.loggingInbox.ordinal = ordinal;
            super.process(ordinal, this.loggingInbox);
        } else {
            super.process(ordinal, inbox);
        }
    }

    private void log(String prefix, @Nonnull T object) {
        if (this.shouldLogFn.test(object)) {
            Object object2;
            String string = String.valueOf(this.toStringFn.apply(object));
            if (object instanceof JetEvent) {
                JetEvent jetEvent = (JetEvent)object;
                object2 = " (eventTime=" + com.hazelcast.jet.impl.util.Util.toLocalTime(jetEvent.timestamp()) + ")";
            } else {
                object2 = "";
            }
            this.logger.info(prefix + ": " + string + (String)object2);
        }
    }

    @Override
    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        if (this.peekInput && !this.peekedWatermarkLogged) {
            this.logger.info("Input coalesced WM: " + String.valueOf(watermark));
            this.peekedWatermarkLogged = true;
        }
        if (super.tryProcessWatermark(watermark)) {
            this.peekedWatermarkLogged = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryProcessWatermark(int ordinal, @Nonnull Watermark watermark) {
        if (this.peekInput && !this.peekedWatermarkLogged) {
            this.logger.info("Input edge WM, ordinal=" + ordinal + ", wm=" + String.valueOf(watermark));
            this.peekedWatermarkLogged = true;
        }
        if (super.tryProcessWatermark(ordinal, watermark)) {
            this.peekedWatermarkLogged = false;
            return true;
        }
        return false;
    }

    private class LoggingInbox
    implements Inbox {
        private Inbox wrappedInbox;
        private int ordinal;

        private LoggingInbox() {
        }

        @Override
        public boolean isEmpty() {
            return this.wrappedInbox.isEmpty();
        }

        @Override
        public Object peek() {
            return this.wrappedInbox.peek();
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            final Iterator<Object> it = this.wrappedInbox.iterator();
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Object next() {
                    return it.next();
                }
            };
        }

        @Override
        public Object poll() {
            Object res = this.wrappedInbox.poll();
            if (res != null) {
                this.log(res);
            }
            return res;
        }

        private void log(@Nonnull T res) {
            PeekWrappedP.this.log("Input from ordinal " + this.ordinal, res);
        }

        @Override
        public void remove() {
            if (this.poll() == null) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void clear() {
            while (this.poll() != null) {
            }
        }

        @Override
        public int size() {
            return this.wrappedInbox.size();
        }
    }

    private final class LoggingOutbox
    implements Outbox {
        private final Outbox wrappedOutbox;
        private final int[] all;
        private final boolean logOutput;
        private final boolean logSnapshot;
        private final BitSet broadcastTracker;

        private LoggingOutbox(Outbox wrappedOutbox, boolean logOutput, boolean logSnapshot) {
            this.wrappedOutbox = wrappedOutbox;
            this.broadcastTracker = new BitSet(wrappedOutbox.bucketCount());
            this.all = IntStream.range(0, wrappedOutbox.bucketCount()).toArray();
            this.logOutput = logOutput;
            this.logSnapshot = logSnapshot;
        }

        @Override
        public int bucketCount() {
            return this.wrappedOutbox.bucketCount();
        }

        @Override
        public boolean offer(int ordinal, @Nonnull Object item) {
            if (ordinal == -1) {
                return this.offer(this.all, item);
            }
            if (!this.wrappedOutbox.offer(ordinal, item)) {
                return false;
            }
            if (this.logOutput) {
                String prefix = "Output to ordinal " + ordinal;
                if (item instanceof Watermark) {
                    PeekWrappedP.this.logger.info(prefix + ": " + String.valueOf(item));
                } else {
                    PeekWrappedP.this.log(prefix, item);
                }
            }
            return true;
        }

        @Override
        public boolean offer(@Nonnull int[] ordinals, @Nonnull Object item) {
            for (int i = 0; i < ordinals.length; ++i) {
                if (this.broadcastTracker.get(i)) continue;
                if (this.offer(i, item)) {
                    this.broadcastTracker.set(i);
                    continue;
                }
                return false;
            }
            this.broadcastTracker.clear();
            return true;
        }

        @Override
        public boolean offerToSnapshot(@Nonnull Object key, @Nonnull Object value) {
            if (!this.wrappedOutbox.offerToSnapshot(key, value)) {
                return false;
            }
            if (this.logSnapshot) {
                PeekWrappedP.this.log("Output to snapshot", Util.entry(key, value));
            }
            return true;
        }

        @Override
        public boolean hasUnfinishedItem() {
            return this.wrappedOutbox.hasUnfinishedItem();
        }
    }
}

