/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.operation.AsyncMasterAwareJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.Subject;

public class SubmitJobOperation
extends AsyncMasterAwareJobOperation {
    private transient Object deserializedJobDefinition;
    private transient JobConfig deserializedJobConfig;
    private Data serializedJobDefinition;
    private Data serializedJobConfig;
    private boolean isLightJob;
    private Subject subject;

    public SubmitJobOperation() {
    }

    public SubmitJobOperation(long jobId, Object deserializedJobDefinition, JobConfig deserializedJobConfig, Data serializedJobDefinition, Data serializedJobConfig, boolean isLightJob, Subject subject) {
        super(jobId);
        this.deserializedJobDefinition = deserializedJobDefinition;
        this.deserializedJobConfig = deserializedJobConfig;
        this.serializedJobDefinition = serializedJobDefinition;
        this.serializedJobConfig = serializedJobConfig;
        this.isLightJob = isLightJob;
        this.subject = subject;
    }

    public CompletableFuture<Void> doRun() {
        JobConfig jobConfig;
        JobConfig jobConfig2 = jobConfig = this.deserializedJobConfig != null ? this.deserializedJobConfig : (JobConfig)this.getNodeEngine().getSerializationService().toObject(this.serializedJobConfig);
        if (this.isLightJob) {
            if (this.deserializedJobDefinition != null) {
                return this.getJobCoordinationService().submitLightJob(this.jobId(), this.deserializedJobDefinition, null, jobConfig, this.subject);
            }
            return this.getJobCoordinationService().submitLightJob(this.jobId(), null, this.serializedJobDefinition, jobConfig, this.subject);
        }
        assert (this.deserializedJobDefinition == null);
        return this.getJobCoordinationService().submitJob(this.jobId(), this.serializedJobDefinition, jobConfig, this.subject);
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        assert (this.serializedJobDefinition != null);
        assert (this.serializedJobConfig != null);
        assert (this.deserializedJobDefinition == null);
        assert (this.deserializedJobConfig == null);
        IOUtil.writeData(out, this.serializedJobDefinition);
        IOUtil.writeData(out, this.serializedJobConfig);
        out.writeBoolean(this.isLightJob);
        out.writeObject(this.subject);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.serializedJobDefinition = IOUtil.readData(in);
        this.serializedJobConfig = IOUtil.readData(in);
        this.isLightJob = in.readBoolean();
        this.subject = (Subject)in.readObject();
    }

    @Override
    public boolean isRequireMasterExecution() {
        return !this.isLightJob;
    }
}

