/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics;

import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.jet.core.metrics.Metric;
import com.hazelcast.jet.core.metrics.Unit;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public class MetricsContext
implements DynamicMetricsProvider {
    private static final BiFunction<String, Unit, AbstractMetric> CREATE_SINGLE_WRITER_METRIC = SingleWriterMetric::new;
    private static final BiFunction<String, Unit, AbstractMetric> CREATE_THREAD_SAFE_METRICS = ThreadSafeMetric::new;
    private volatile Map<String, AbstractMetric> metrics;

    Metric metric(String name, Unit unit) {
        return this.metric(name, unit, CREATE_SINGLE_WRITER_METRIC);
    }

    Metric threadSafeMetric(String name, Unit unit) {
        return this.metric(name, unit, CREATE_THREAD_SAFE_METRICS);
    }

    private Metric metric(String name, Unit unit, BiFunction<String, Unit, AbstractMetric> metricSupplier) {
        AbstractMetric metric;
        if (this.metrics == null) {
            this.metrics = new ConcurrentHashMap<String, AbstractMetric>();
        }
        if ((metric = this.metrics.get(name)) != null) {
            return metric;
        }
        metric = metricSupplier.apply(name, unit);
        this.metrics.put(name, metric);
        return metric;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor tagger, MetricsCollectionContext context) {
        if (this.metrics != null) {
            MetricDescriptor withUserTag = MetricsContext.addUserTag(tagger);
            this.metrics.forEach((name, metric) -> context.collect(withUserTag, (String)name, ProbeLevel.INFO, this.toProbeUnit(metric.unit()), metric.get()));
        }
    }

    private static MetricDescriptor addUserTag(MetricDescriptor tagger) {
        return tagger.copy().withTag("user", "true");
    }

    private ProbeUnit toProbeUnit(Unit unit) {
        return ProbeUnit.valueOf(unit.name());
    }

    private static abstract class AbstractMetric
    implements Metric {
        private final String name;
        private final Unit unit;

        AbstractMetric(String name, Unit unit) {
            this.name = name;
            this.unit = unit;
        }

        @Override
        @Nonnull
        public String name() {
            return this.name;
        }

        @Override
        @Nonnull
        public Unit unit() {
            return this.unit;
        }

        protected abstract long get();
    }

    private static final class ThreadSafeMetric
    extends AbstractMetric {
        private static final AtomicLongFieldUpdater<ThreadSafeMetric> VOLATILE_VALUE_UPDATER = AtomicLongFieldUpdater.newUpdater(ThreadSafeMetric.class, "value");
        private volatile long value;

        ThreadSafeMetric(String name, Unit unit) {
            super(name, unit);
        }

        @Override
        public void increment() {
            VOLATILE_VALUE_UPDATER.incrementAndGet(this);
        }

        @Override
        public void increment(long amount) {
            VOLATILE_VALUE_UPDATER.addAndGet(this, amount);
        }

        @Override
        public void decrement() {
            VOLATILE_VALUE_UPDATER.decrementAndGet(this);
        }

        @Override
        public void decrement(long amount) {
            VOLATILE_VALUE_UPDATER.addAndGet(this, -amount);
        }

        @Override
        public void set(long newValue) {
            VOLATILE_VALUE_UPDATER.set(this, newValue);
        }

        @Override
        protected long get() {
            return VOLATILE_VALUE_UPDATER.get(this);
        }
    }

    private static final class SingleWriterMetric
    extends AbstractMetric {
        private static final VarHandle VALUE = ReflectionUtil.findVarHandle("value", Long.TYPE);
        private volatile long value;

        SingleWriterMetric(String name, Unit unit) {
            super(name, unit);
        }

        @Override
        public void set(long newValue) {
            VALUE.setOpaque(this, newValue);
        }

        @Override
        public void increment() {
            VALUE.setOpaque(this, this.value + 1L);
        }

        @Override
        public void increment(long increment) {
            VALUE.setOpaque(this, this.value + increment);
        }

        @Override
        public void decrement() {
            VALUE.setOpaque(this, this.value - 1L);
        }

        @Override
        public void decrement(long decrement) {
            VALUE.setOpaque(this, this.value - decrement);
        }

        @Override
        protected long get() {
            return this.value;
        }
    }
}

