/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetGetJobIdsCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.cluster.Member;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.security.permission.JobPermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.security.Permission;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class JetGetJobIdsMessageTask
extends AbstractAsyncMessageTask<JetGetJobIdsCodec.RequestParameters, Object> {
    JetGetJobIdsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<Object> processInternal() {
        GetJobIdsOperation masterOperation = new GetJobIdsOperation(((JetGetJobIdsCodec.RequestParameters)this.parameters).onlyName, ((JetGetJobIdsCodec.RequestParameters)this.parameters).onlyJobId, false);
        Invocation masterInvocation = this.nodeEngine.getOperationService().createMasterInvocationBuilder("hz:impl:jetService", masterOperation).build();
        InvocationFuture masterFuture = masterInvocation.invoke();
        if (((JetGetJobIdsCodec.RequestParameters)this.parameters).onlyName != null) {
            return ((CompletableFuture)masterFuture).handleAsync((result, throwable) -> {
                if (throwable != null) {
                    ExceptionUtil.sneakyThrow(throwable);
                }
                Map<UUID, GetJobIdsOperation.GetJobIdsResult> results = MapUtil.createHashMap(1);
                results.put(masterInvocation.getTargetMember().getUuid(), (GetJobIdsOperation.GetJobIdsResult)result);
                return results;
            }, ConcurrencyUtil.CALLER_RUNS);
        }
        Supplier<Operation> operationSupplier = () -> new GetJobIdsOperation(((JetGetJobIdsCodec.RequestParameters)this.parameters).onlyName, ((JetGetJobIdsCodec.RequestParameters)this.parameters).onlyJobId, true).setCallerUuid(this.endpoint.getUuid());
        CompletableFuture<Map> allMembersFuture = InvocationUtil.invokeAndReduceOnAllClusterMembers(this.nodeEngine, operationSupplier, (r, t) -> {
            if (t == null) {
                return r;
            }
            return GetJobIdsOperation.GetJobIdsResult.EMPTY;
        }, m -> m.entrySet().stream().collect(Collectors.toMap(en -> ((Member)en.getKey()).getUuid(), Map.Entry::getValue)));
        return ((CompletableFuture)masterFuture).thenCombine(allMembersFuture, (masterResult, allMemberResults) -> {
            allMemberResults.put(masterInvocation.getTargetMember().getUuid(), masterResult);
            return allMemberResults;
        });
    }

    @Override
    protected JetGetJobIdsCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return JetGetJobIdsCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return JetGetJobIdsCodec.encodeResponse(this.serializationService.toData(response));
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getJobIds";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public String getServiceName() {
        return "hz:impl:jetService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new JobPermission(new String[]{"read"});
    }
}

