/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractInvocationMessageTask;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.security.permission.JobPermission;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;

abstract class AbstractJetMessageTask<P, R>
extends AbstractInvocationMessageTask<P> {
    private final Function<ClientMessage, P> decoder;
    private final Function<R, ClientMessage> encoder;

    protected AbstractJetMessageTask(ClientMessage clientMessage, Node node, Connection connection, Function<ClientMessage, P> decoder, Function<R, ClientMessage> encoder) {
        super(clientMessage, node, connection);
        this.decoder = decoder;
        this.encoder = encoder;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:jetService";
    }

    @Override
    protected final P decodeClientMessage(ClientMessage clientMessage) {
        return this.decoder.apply(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object o) {
        return this.encoder.apply(o);
    }

    @Override
    public final Permission getRequiredPermission() {
        String[] actions = this.actions();
        if (actions != null) {
            return new JobPermission(actions);
        }
        return null;
    }

    @Nullable
    public String[] actions() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    protected <V> Data toData(V v) {
        return this.nodeEngine.getSerializationService().toData(v);
    }

    protected UUID getLightJobCoordinator() {
        return null;
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation operation) {
        if (this.getLightJobCoordinator() != null) {
            MemberImpl member = this.nodeEngine.getClusterService().getMember(this.getLightJobCoordinator());
            if (member == null) {
                throw new TopologyChangedException("Light job coordinator left the cluster");
            }
            return this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", operation, member.getAddress());
        }
        return this.nodeEngine.getOperationService().createMasterInvocationBuilder("hz:impl:jetService", operation);
    }

    protected JetServiceBackend getJetServiceBackend() {
        return (JetServiceBackend)this.getService("hz:impl:jetService");
    }
}

