/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Inbox
extends Iterable<Object> {
    public boolean isEmpty();

    @Nullable
    public Object peek();

    @Nullable
    public Object poll();

    public void remove();

    @Override
    @Nonnull
    public Iterator<Object> iterator();

    public void clear();

    default public <E> int drainTo(Collection<E> target) {
        return this.drainTo(target, Integer.MAX_VALUE);
    }

    default public <E> int drainTo(@Nonnull Collection<E> target, int limit) {
        Object o;
        int drained;
        for (drained = 0; drained < limit && (o = this.poll()) != null; ++drained) {
            target.add(o);
        }
        return drained;
    }

    default public <E, M> int drainTo(@Nonnull Collection<M> target, int limit, @Nonnull Function<E, M> mapper) {
        Object o;
        int drained;
        for (drained = 0; drained < limit && (o = this.poll()) != null; ++drained) {
            target.add(mapper.apply(o));
        }
        return drained;
    }

    default public <E> int drain(@Nonnull Consumer<E> consumer) {
        for (Object o : this) {
            consumer.accept(o);
        }
        int consumed = this.size();
        this.clear();
        return consumed;
    }

    public int size();
}

