/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.collection;

import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import java.lang.invoke.VarHandle;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class ReadOptimizedLruCache<K, V> {
    final ConcurrentMap<K, ValueAndTimestamp<V>> cache;
    private final AtomicBoolean cleanupLock = new AtomicBoolean();
    private final int capacity;
    private final int cleanupThreshold;

    public ReadOptimizedLruCache(int capacity, int cleanupThreshold) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity <= 0");
        }
        if (cleanupThreshold <= capacity) {
            throw new IllegalArgumentException("cleanupThreshold <= capacity");
        }
        this.capacity = capacity;
        this.cleanupThreshold = cleanupThreshold;
        this.cache = new ConcurrentHashMap<K, ValueAndTimestamp<V>>(cleanupThreshold);
    }

    public V getOrDefault(K key, V defaultValue) {
        V existingValue = this.get(key);
        return existingValue != null ? existingValue : defaultValue;
    }

    public V get(K key) {
        ValueAndTimestamp valueFromCache = (ValueAndTimestamp)this.cache.get(key);
        if (valueFromCache == null) {
            return null;
        }
        valueFromCache.touch();
        return valueFromCache.value;
    }

    public void put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values are disallowed");
        }
        ValueAndTimestamp<V> oldValue = this.cache.put(key, new ValueAndTimestamp<V>(value));
        if (oldValue == null && this.cache.size() > this.cleanupThreshold) {
            this.doCleanup();
        }
    }

    public V computeIfAbsent(K key, Function<K, V> mappingFn) {
        V value = this.get(key);
        if (value != null) {
            return value;
        }
        value = mappingFn.apply(key);
        this.put(key, value);
        return value;
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup() {
        if (!this.cleanupLock.compareAndSet(false, true)) {
            return;
        }
        try {
            int entriesToRemove = this.cache.size() - this.capacity;
            if (entriesToRemove <= 0) {
                return;
            }
            PriorityQueue oldestTimestamps = new PriorityQueue(entriesToRemove + 1, Comparator.naturalOrder().reversed());
            for (ValueAndTimestamp valueAndTimestamp : this.cache.values()) {
                oldestTimestamps.add(valueAndTimestamp.timestamp);
                if (oldestTimestamps.size() <= entriesToRemove) continue;
                oldestTimestamps.poll();
            }
            if (oldestTimestamps.isEmpty()) {
                return;
            }
            long removeThreshold = (Long)oldestTimestamps.poll();
            this.cache.values().removeIf(v -> v.timestamp <= removeThreshold);
        }
        finally {
            this.cleanupLock.set(false);
        }
    }

    public int size() {
        return this.cache.size();
    }

    static class ValueAndTimestamp<V> {
        private static final VarHandle TIMESTAMP = ReflectionUtil.findVarHandle("timestamp", Long.TYPE);
        final V value;
        volatile long timestamp;

        ValueAndTimestamp(V value) {
            this.value = value;
            this.touch();
        }

        public void touch() {
            TIMESTAMP.setOpaque(this, System.nanoTime());
        }
    }
}

