/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.net;

import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import java.lang.invoke.VarHandle;

public class AsyncSocketMetrics {
    private static final VarHandle BYTES_READ = ReflectionUtil.findVarHandle("bytesRead", Long.TYPE);
    private static final VarHandle BYTES_WRITTEN = ReflectionUtil.findVarHandle("bytesWritten", Long.TYPE);
    private static final VarHandle WRITE_EVENTS = ReflectionUtil.findVarHandle("writeEvents", Long.TYPE);
    private static final VarHandle READ_EVENTS = ReflectionUtil.findVarHandle("readEvents", Long.TYPE);
    private volatile long bytesRead;
    private volatile long bytesWritten;
    private volatile long writeEvents;
    private volatile long readEvents;

    public long bytesRead() {
        return BYTES_READ.getOpaque(this);
    }

    public void incBytesRead(long delta) {
        BYTES_READ.setOpaque(this, BYTES_READ.getOpaque(this) + delta);
    }

    public long bytesWritten() {
        return BYTES_WRITTEN.getOpaque(this);
    }

    public void incBytesWritten(long delta) {
        BYTES_WRITTEN.setOpaque(this, BYTES_WRITTEN.getOpaque(this) + delta);
    }

    public long writeEvents() {
        return WRITE_EVENTS.getOpaque(this);
    }

    public void incWriteEvents() {
        WRITE_EVENTS.setOpaque(this, WRITE_EVENTS.getOpaque(this) + 1L);
    }

    public long readEvents() {
        return READ_EVENTS.getOpaque(this);
    }

    public void incReadEvents() {
        READ_EVENTS.setOpaque(this, READ_EVENTS.getOpaque(this) + 1L);
    }
}

