/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine;

import com.hazelcast.internal.tpcengine.Promise;
import com.hazelcast.internal.tpcengine.PromiseAllocator;
import com.hazelcast.internal.tpcengine.Reactor;
import com.hazelcast.internal.tpcengine.ReactorBuilder;
import com.hazelcast.internal.tpcengine.ScheduledTask;
import com.hazelcast.internal.tpcengine.Scheduler;
import com.hazelcast.internal.tpcengine.logging.TpcLogger;
import com.hazelcast.internal.tpcengine.logging.TpcLoggerLocator;
import com.hazelcast.internal.tpcengine.util.BoundPriorityQueue;
import com.hazelcast.internal.tpcengine.util.CachedNanoClock;
import com.hazelcast.internal.tpcengine.util.CircularQueue;
import com.hazelcast.internal.tpcengine.util.NanoClock;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import com.hazelcast.internal.tpcengine.util.StandardNanoClock;
import com.hazelcast.shaded.org.jctools.queues.MpmcArrayQueue;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Eventloop {
    private static final int INITIAL_ALLOCATOR_CAPACITY = 1024;
    protected final MpmcArrayQueue externalTaskQueue;
    protected final PriorityQueue<ScheduledTask> scheduledTaskQueue;
    public final CircularQueue localTaskQueue;
    protected final Reactor reactor;
    protected final boolean spin;
    protected final int batchSize;
    protected final ReactorBuilder builder;
    protected final TpcLogger logger = TpcLoggerLocator.getLogger(this.getClass());
    protected final AtomicBoolean wakeupNeeded = new AtomicBoolean(true);
    protected final NanoClock nanoClock;
    protected final PromiseAllocator promiseAllocator;
    protected final Scheduler scheduler;
    protected long earliestDeadlineNanos = -1L;
    protected boolean stop;

    protected Eventloop(Reactor reactor, ReactorBuilder builder) {
        this.reactor = reactor;
        this.builder = builder;
        this.scheduledTaskQueue = new BoundPriorityQueue<ScheduledTask>(builder.scheduledTaskQueueCapacity);
        this.localTaskQueue = new CircularQueue(builder.localTaskQueueCapacity);
        this.externalTaskQueue = new MpmcArrayQueue(builder.externalTaskQueueCapacity);
        this.spin = builder.spin;
        this.batchSize = builder.batchSize;
        this.promiseAllocator = new PromiseAllocator(this, 1024);
        this.nanoClock = builder.clockRefreshPeriod == 0 ? new StandardNanoClock() : new CachedNanoClock(builder.clockRefreshPeriod);
        this.scheduler = builder.schedulerSupplier.get();
        this.scheduler.init(this);
    }

    protected abstract void run() throws Exception;

    protected void destroy() throws Exception {
    }

    protected final boolean runScheduledTasks() {
        PriorityQueue<ScheduledTask> scheduledTaskQueue0 = this.scheduledTaskQueue;
        NanoClock nanoClock0 = this.nanoClock;
        int batchSize0 = this.batchSize;
        for (int k = 0; k < batchSize0; ++k) {
            ScheduledTask scheduledTask = scheduledTaskQueue0.peek();
            if (scheduledTask == null) {
                return false;
            }
            if (scheduledTask.deadlineNanos > nanoClock0.nanoTime()) {
                this.earliestDeadlineNanos = scheduledTask.deadlineNanos;
                return false;
            }
            scheduledTaskQueue0.poll();
            this.earliestDeadlineNanos = -1L;
            try {
                scheduledTask.run();
                continue;
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        }
        return !scheduledTaskQueue0.isEmpty();
    }

    protected final boolean runLocalTasks() {
        int batchSize0 = this.batchSize;
        CircularQueue localTaskQueue0 = this.localTaskQueue;
        for (int k = 0; k < batchSize0; ++k) {
            Object task = localTaskQueue0.poll();
            if (task == null) {
                return false;
            }
            if (task instanceof Runnable) {
                Runnable runnable = (Runnable)task;
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    this.logger.warning(e);
                }
                continue;
            }
            try {
                this.scheduler.schedule(task);
                continue;
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        }
        return !localTaskQueue0.isEmpty();
    }

    protected final boolean runExternalTasks() {
        int batchSize0 = this.batchSize;
        MpmcArrayQueue externalTaskQueue0 = this.externalTaskQueue;
        Scheduler scheduler0 = this.scheduler;
        for (int k = 0; k < batchSize0; ++k) {
            Object task = externalTaskQueue0.poll();
            if (task == null) {
                return false;
            }
            if (task instanceof Runnable) {
                Runnable runnable = (Runnable)task;
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    this.logger.warning(e);
                }
                continue;
            }
            try {
                scheduler0.schedule(task);
                continue;
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        }
        return !externalTaskQueue0.isEmpty();
    }

    public final boolean schedule(Runnable task, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(task);
        Preconditions.checkNotNegative(delay, "delay");
        Preconditions.checkNotNull(unit);
        ScheduledTask scheduledTask = new ScheduledTask(this);
        scheduledTask.task = task;
        long deadlineNanos = this.nanoClock.nanoTime() + unit.toNanos(delay);
        if (deadlineNanos < 0L) {
            deadlineNanos = Long.MAX_VALUE;
        }
        scheduledTask.deadlineNanos = deadlineNanos;
        return this.scheduledTaskQueue.offer(scheduledTask);
    }

    public final boolean scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(task);
        Preconditions.checkNotNegative(initialDelay, "initialDelay");
        Preconditions.checkNotNegative(delay, "delay");
        Preconditions.checkNotNull(unit);
        ScheduledTask scheduledTask = new ScheduledTask(this);
        scheduledTask.task = task;
        long deadlineNanos = this.nanoClock.nanoTime() + unit.toNanos(initialDelay);
        if (deadlineNanos < 0L) {
            deadlineNanos = Long.MAX_VALUE;
        }
        scheduledTask.deadlineNanos = deadlineNanos;
        scheduledTask.delayNanos = unit.toNanos(delay);
        return this.scheduledTaskQueue.offer(scheduledTask);
    }

    public final boolean scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        Preconditions.checkNotNull(task);
        Preconditions.checkNotNegative(initialDelay, "initialDelay");
        Preconditions.checkNotNegative(period, "period");
        Preconditions.checkNotNull(unit);
        ScheduledTask scheduledTask = new ScheduledTask(this);
        scheduledTask.task = task;
        long deadlineNanos = this.nanoClock.nanoTime() + unit.toNanos(initialDelay);
        if (deadlineNanos < 0L) {
            deadlineNanos = Long.MAX_VALUE;
        }
        scheduledTask.deadlineNanos = deadlineNanos;
        scheduledTask.periodNanos = unit.toNanos(period);
        return this.scheduledTaskQueue.offer(scheduledTask);
    }

    public final Promise sleep(long delay, TimeUnit unit) {
        Preconditions.checkNotNegative(delay, "delay");
        Preconditions.checkNotNull(unit, "unit");
        Promise promise = this.promiseAllocator.allocate();
        ScheduledTask scheduledTask = new ScheduledTask(this);
        scheduledTask.promise = promise;
        long deadlineNanos = this.nanoClock.nanoTime() + unit.toNanos(delay);
        if (deadlineNanos < 0L) {
            deadlineNanos = Long.MAX_VALUE;
        }
        scheduledTask.deadlineNanos = deadlineNanos;
        this.scheduledTaskQueue.add(scheduledTask);
        return promise;
    }
}

