/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.schema;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaReplication;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaReplicationStatus;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaReplicator;
import com.hazelcast.internal.util.FutureUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class SchemaReplicationsMerger
implements Runnable {
    private final SchemaReplicator replicator;
    private final Collection<SchemaReplication> replications;

    public SchemaReplicationsMerger(SchemaReplicator replicator, Collection<SchemaReplication> replications) {
        this.replicator = replicator;
        this.replications = replications;
    }

    @Override
    public void run() {
        try {
            List replicationFutures = this.replications.stream().filter(replication -> {
                SchemaReplicationStatus status = this.replicator.getReplicationStatus(replication.getSchema());
                if (status == null) {
                    return true;
                }
                return status != SchemaReplicationStatus.REPLICATED;
            }).map(replication -> this.replicator.replicate(replication.getSchema())).collect(Collectors.toList());
            FutureUtil.waitForever(replicationFutures, FutureUtil.RETHROW_EVERYTHING);
        }
        catch (Exception e) {
            throw new HazelcastException("Error while replaying replications " + String.valueOf(this.replications), e);
        }
    }
}

