/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.schema;

import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.SchemaService;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaReplication;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaReplicationsMerger;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaReplicator;
import com.hazelcast.internal.serialization.impl.compact.schema.SendSchemaReplicationsOperation;
import com.hazelcast.internal.services.CoreService;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.PreJoinAwareService;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MemberSchemaService
implements ManagedService,
PreJoinAwareService<SendSchemaReplicationsOperation>,
SchemaService,
SplitBrainHandlerService,
CoreService {
    private final ConcurrentHashMap<Long, Schema> schemas = new ConcurrentHashMap();
    private final SchemaReplicator replicator = new SchemaReplicator(this);
    private ILogger logger;

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.logger = nodeEngine.getLogger(SchemaService.class);
        this.replicator.init(nodeEngine);
    }

    @Override
    public void reset() {
        this.replicator.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.schemas.clear();
        this.replicator.clear();
    }

    @Override
    @Nullable
    public Schema get(long schemaId) {
        return this.schemas.get(schemaId);
    }

    @Override
    public void put(Schema schema) {
        this.putAsync(schema).join();
    }

    public InternalCompletableFuture<Collection<UUID>> putAsync(Schema schema) {
        return this.replicator.replicate(schema);
    }

    public InternalCompletableFuture<Void> putAllAsync(List<Schema> schemas) {
        if (schemas.isEmpty()) {
            return InternalCompletableFuture.newCompletedFuture(null);
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Putting schemas to the cluster%s", schemas);
        }
        return this.replicator.replicateAll(schemas);
    }

    @Override
    public void putLocal(Schema schema) {
        long schemaId = schema.getSchemaId();
        Schema existingSchema = this.schemas.putIfAbsent(schemaId, schema);
        if (existingSchema == null) {
            return;
        }
        if (!schema.equals(existingSchema)) {
            throw new IllegalStateException("Schema with schemaId " + schemaId + " already exists. Existing schema " + String.valueOf(existingSchema) + "new schema " + String.valueOf(schema));
        }
    }

    public Collection<Schema> getAllSchemas() {
        return this.schemas.values();
    }

    @Override
    public SendSchemaReplicationsOperation getPreJoinOperation() {
        Collection<SchemaReplication> replications = this.replicator.getReplications();
        if (replications.isEmpty()) {
            return null;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Preparing pre-join operation with replications %s", replications);
        }
        return new SendSchemaReplicationsOperation(replications);
    }

    public void replayReplications(Collection<SchemaReplication> replications) {
        for (SchemaReplication replication : replications) {
            Schema schema = replication.getSchema();
            this.putLocal(schema);
        }
        List<Schema> schemas = replications.stream().map(SchemaReplication::getSchema).collect(Collectors.toList());
        this.persistAllSchemasToHotRestart(schemas);
        this.replicator.setReplications(replications);
    }

    public void onSchemaPreparationRequest(Schema schema) {
        if (this.replicator.getReplicationStatus(schema) != null) {
            return;
        }
        this.putLocal(schema);
        this.persistSchemaToHotRestart(schema);
        this.replicator.markSchemaAsPrepared(schema);
    }

    public void onSchemaAckRequest(long schemaId) {
        this.replicator.markSchemaAsReplicated(schemaId);
    }

    public void onHotRestartRestore(Collection<Schema> schemas) {
        for (Schema schema : schemas) {
            this.putLocal(schema);
            this.replicator.markSchemaAsPrepared(schema);
        }
    }

    @Override
    public Runnable prepareMergeRunnable() {
        Collection<SchemaReplication> replications = this.replicator.getReplications();
        return new SchemaReplicationsMerger(this.replicator, replications);
    }

    private void persistSchemaToHotRestart(Schema schema) {
        this.persistSchemaToHotRestartAsync(schema).join();
    }

    protected void persistAllSchemasToHotRestart(Collection<Schema> schemas) {
    }

    protected InternalCompletableFuture<Void> persistSchemaToHotRestartAsync(Schema schema) {
        return InternalCompletableFuture.newCompletedFuture(null);
    }

    SchemaReplicator getReplicator() {
        return this.replicator;
    }
}

