/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import java.util.UUID;

public class ShutdownRequestOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation,
Versioned {
    private UUID uuid;

    public ShutdownRequestOperation() {
    }

    public ShutdownRequestOperation(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public void run() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        ILogger logger = this.getLogger();
        Address caller = this.getCallerAddress();
        if (partitionService.isLocalMemberMaster()) {
            ClusterService clusterService = this.getNodeEngine().getClusterService();
            MemberImpl member = clusterService.getMember(caller);
            if (member != null) {
                if (logger.isFinestEnabled()) {
                    logger.finest("Received shutdown request from %s", caller);
                }
                if (member.getUuid().equals(this.uuid)) {
                    partitionService.onShutdownRequest(member);
                } else {
                    logger.warning("Ignoring shutdown request from " + String.valueOf(this.uuid) + " because it is not a member");
                }
            } else {
                logger.warning("Ignoring shutdown request from " + String.valueOf(caller) + " because it is not a member");
            }
        } else {
            logger.warning("Received shutdown request from " + String.valueOf(caller) + " but this node is not master.");
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public int getClassId() {
        return 13;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.uuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.uuid = UUIDSerializationUtil.readUUID(in);
    }
}

