/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;

public class SafeStateCheckOperation
extends AbstractPartitionOperation
implements AllowedDuringPassiveState {
    private transient boolean safe;
    private transient boolean throwWhenTargetNotMember;

    public SafeStateCheckOperation() {
    }

    public SafeStateCheckOperation(boolean throwWhenTargetNotMember) {
        this.throwWhenTargetNotMember = throwWhenTargetNotMember;
    }

    @Override
    public void run() throws Exception {
        InternalPartitionService service = (InternalPartitionService)this.getService();
        this.safe = service.isMemberStateSafe();
    }

    @Override
    public Object getResponse() {
        return this.safe;
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return throwable instanceof TargetNotMemberException && this.throwWhenTargetNotMember ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }
}

