/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class ChunkSuppliers {
    private ChunkSuppliers() {
    }

    public static ChunkSupplier newSingleChunkSupplier(Supplier<Operation> operationSupplier) {
        Preconditions.isNotNull(operationSupplier, "operationSupplier");
        return new SingleChunkSupplier(operationSupplier);
    }

    public static ChunkSupplier newChainedChunkSupplier(List<ChunkSupplier> chain) {
        Preconditions.isNotNull(chain, "chain");
        Preconditions.checkTrue(CollectionUtil.isNotEmpty(chain), "chain cannot be an empty list");
        Preconditions.checkNoNullInside(chain, "chain cannot have null value inside");
        return new ChainedChunkSupplier(chain);
    }

    private static final class SingleChunkSupplier
    implements ChunkSupplier {
        private final Supplier<Operation> operationSupplier;
        private boolean hasMoreChunks = true;

        private SingleChunkSupplier(Supplier<Operation> operationSupplier) {
            this.operationSupplier = operationSupplier;
        }

        @Override
        @Nullable
        public Operation next() {
            if (!this.hasMoreChunks) {
                throw new NoSuchElementException();
            }
            Operation operation = this.operationSupplier.get();
            this.hasMoreChunks = false;
            return operation;
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreChunks;
        }

        public String toString() {
            return "SingleChunkSupplier{operationSupplier=" + String.valueOf(this.operationSupplier) + ", hasMoreChunks=" + this.hasMoreChunks + "}";
        }
    }

    private static final class ChainedChunkSupplier
    implements ChunkSupplier {
        private final List<ChunkSupplier> chain;

        private ChainedChunkSupplier(List<ChunkSupplier> chain) {
            this.chain = chain;
        }

        @Override
        public void signalEndOfChunkWith(Predicate<BufferObjectDataOutput> isEndOfChunk) {
            for (int i = 0; i < this.chain.size(); ++i) {
                this.chain.get(i).signalEndOfChunkWith(isEndOfChunk);
            }
        }

        @Override
        public boolean hasNext() {
            for (int i = 0; i < this.chain.size(); ++i) {
                if (!this.chain.get(i).hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Operation next() {
            for (int i = 0; i < this.chain.size(); ++i) {
                ChunkSupplier chunkSupplier = this.chain.get(i);
                if (!chunkSupplier.hasNext()) continue;
                return (Operation)chunkSupplier.next();
            }
            throw new NoSuchElementException();
        }

        public String toString() {
            return "ChunkSupplierChain{length=" + this.chain.size() + ", chain=" + String.valueOf(this.chain) + "}";
        }
    }
}

