/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ascii;

import com.hazelcast.config.RestApiConfig;
import com.hazelcast.config.RestEndpointGroup;
import com.hazelcast.internal.nio.ascii.TextParsers;
import com.hazelcast.internal.nio.ascii.TextProtocolFilter;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import java.util.StringTokenizer;

public class RestApiFilter
implements TextProtocolFilter {
    private final ILogger logger;
    private final RestApiConfig restApiConfig;
    private final TextParsers parsers;

    RestApiFilter(LoggingService loggingService, RestApiConfig restApiConfig, TextParsers parsers) {
        this.logger = loggingService.getLogger(this.getClass());
        this.restApiConfig = restApiConfig;
        this.parsers = parsers;
    }

    @Override
    public void filterConnection(String commandLine, ServerConnection connection) {
        RestEndpointGroup restEndpointGroup = this.getEndpointGroup(commandLine);
        if (restEndpointGroup != null) {
            if (!this.restApiConfig.isGroupEnabled(restEndpointGroup)) {
                String name = restEndpointGroup.name();
                connection.close("REST endpoint group is not enabled - " + String.valueOf((Object)restEndpointGroup) + ". To enable it, do one of the following:\n" + String.format("  - Change member config using Java API: %s\n  - Change XML/YAML configuration property: Set %s\n  - Add system property: %s (for Hazelcast embedded, works only when loading config via Config.load)\n  - Add environment variable: %s (recommended when running container image. For Hazelcast embedded, works only when loading config via Config.load)", "config.getNetworkConfig().getRestApiConfig().enableGroups(RestEndpointGroup." + name + ");", "hazelcast.network.rest-api.endpoint-group " + name + " with `enabled` set to true", "-Dhz.network.rest-api.endpoint-groups." + name.toLowerCase() + ".enabled=true", "HZ_NETWORK_RESTAPI_ENDPOINTGROUPS." + name + ".ENABLED=true"), null);
            }
        } else if (!commandLine.isEmpty()) {
            connection.close("Unsupported command received on REST API handler.", null);
        }
    }

    private RestEndpointGroup getEndpointGroup(String commandLine) {
        if (commandLine == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(commandLine);
        String operation = this.nextToken(st);
        if (this.parsers.getParser(operation) == null) {
            return null;
        }
        String requestUri = this.nextToken(st);
        return requestUri != null ? this.getHttpApiEndpointGroup(operation, requestUri) : null;
    }

    private RestEndpointGroup getHttpApiEndpointGroup(String operation, String requestUri) {
        if (requestUri.startsWith("/hazelcast/rest/maps/") || requestUri.startsWith("/hazelcast/rest/queues/")) {
            return RestEndpointGroup.DATA;
        }
        if (requestUri.startsWith("/hazelcast/health")) {
            return RestEndpointGroup.HEALTH_CHECK;
        }
        if (requestUri.startsWith("/hazelcast/rest/wan")) {
            return RestEndpointGroup.WAN;
        }
        if (requestUri.startsWith("/hazelcast/rest/management/cluster/forceStart") || requestUri.startsWith("/hazelcast/rest/management/cluster/partialStart") || requestUri.startsWith("/hazelcast/rest/management/cluster/backup") || requestUri.startsWith("/hazelcast/rest/management/cluster/backupInterrupt") || requestUri.startsWith("/hazelcast/rest/management/cluster/hotBackup") || requestUri.startsWith("/hazelcast/rest/management/cluster/hotBackupInterrupt")) {
            return RestEndpointGroup.PERSISTENCE;
        }
        if (requestUri.startsWith("/hazelcast/rest/cluster") || requestUri.startsWith("/hazelcast/rest/management/cluster/state") || requestUri.startsWith("/hazelcast/rest/management/cluster/nodes") || "GET".equals(operation) && requestUri.startsWith("/hazelcast/rest/license") || "GET".equals(operation) && requestUri.startsWith("/hazelcast/rest/management/cluster/version") || requestUri.startsWith("/hazelcast/rest/instance") || "GET".equals(operation) && requestUri.startsWith("/hazelcast/rest/log-level") || "GET".equals(operation) && requestUri.startsWith("/hazelcast/rest/config/tcp-ip/member-list")) {
            return RestEndpointGroup.CLUSTER_READ;
        }
        if (requestUri.startsWith("/hazelcast/rest/management/cluster/clusterShutdown") || requestUri.startsWith("/hazelcast/rest/management/cluster/memberShutdown") || requestUri.startsWith("/hazelcast/rest/management/cluster/changeState") || requestUri.startsWith("/hazelcast/rest/management/cluster/version") || requestUri.startsWith("/hazelcast/rest/license") || requestUri.startsWith("/hazelcast/rest/log-level") || requestUri.startsWith("/hazelcast/rest/config/reload") || requestUri.startsWith("/hazelcast/rest/config/update") || requestUri.startsWith("/hazelcast/rest/config/tcp-ip/member-list")) {
            return RestEndpointGroup.CLUSTER_WRITE;
        }
        if (requestUri.startsWith("/hazelcast/rest/cp-subsystem")) {
            return RestEndpointGroup.CP;
        }
        this.logger.warning("No REST group matching URI: " + requestUri);
        return null;
    }

    private String nextToken(StringTokenizer st) {
        return st.hasMoreTokens() ? st.nextToken() : null;
    }
}

