/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio;

import java.util.HashMap;
import java.util.Map;

public final class ConnectionType {
    public static final String NONE = "NONE";
    public static final String MEMBER = "MEMBER";
    public static final String JAVA_CLIENT = "JVM";
    public static final String CSHARP_CLIENT = "CSP";
    public static final String CPP_CLIENT = "CPP";
    public static final String PYTHON_CLIENT = "PYH";
    public static final String NODEJS_CLIENT = "NJS";
    public static final String GO_CLIENT = "GOO";
    public static final String REST_CLIENT = "REST";
    public static final String MEMCACHE_CLIENT = "MEMCACHE";
    public static final String MC_JAVA_CLIENT = "MCJVM";
    public static final String CL_CLIENT = "CLC";
    public static final String MC_CL_CLIENT = "MCCLC";
    private static final Map<String, Integer> ID_MAP = new HashMap<String, Integer>();

    private ConnectionType() {
    }

    public static int getTypeId(String type) {
        return ID_MAP.getOrDefault(type, -1);
    }

    static {
        ID_MAP.put(NONE, 0);
        ID_MAP.put(MEMBER, 1);
        ID_MAP.put(JAVA_CLIENT, 2);
        ID_MAP.put(CPP_CLIENT, 3);
        ID_MAP.put(PYTHON_CLIENT, 4);
        ID_MAP.put(NODEJS_CLIENT, 5);
        ID_MAP.put(GO_CLIENT, 6);
        ID_MAP.put(REST_CLIENT, 7);
        ID_MAP.put(MEMCACHE_CLIENT, 8);
        ID_MAP.put(MC_JAVA_CLIENT, 9);
        ID_MAP.put(CSHARP_CLIENT, 10);
        ID_MAP.put(CL_CLIENT, 11);
        ID_MAP.put(MC_CL_CLIENT, 12);
    }
}

