/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio;

import com.hazelcast.internal.usercodedeployment.impl.ClassSource;
import com.hazelcast.internal.util.ConcurrentReferenceHashMap;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.impl.deployment.MapResourceClassLoader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class ClassLoaderUtil {
    public static final String HAZELCAST_BASE_PACKAGE = "com.hazelcast.";
    public static final String HAZELCAST_ARRAY = "[Lcom.hazelcast.";
    private static final boolean CLASS_CACHE_DISABLED = Boolean.getBoolean("hazelcast.compat.classloading.cache.disabled");
    private static final Map<String, Class> PRIMITIVE_CLASSES_BY_NAME;
    private static final int MAX_PRIM_CLASS_NAME_LENGTH = 7;
    private static final ClassLoaderWeakCache<Constructor> CONSTRUCTOR_CACHE;
    private static final ClassLoaderWeakCache<Class> CLASS_CACHE;
    private static final Constructor<?> IRRESOLVABLE_CONSTRUCTOR;
    private static final ClassLoader NULL_FALLBACK_CLASSLOADER;
    private static final Pattern CLASS_PATTERN;

    private ClassLoaderUtil() {
    }

    public static <T> T getOrCreate(T instance, ClassLoader classLoader, String className) {
        if (instance != null) {
            return instance;
        }
        if (className != null) {
            try {
                return ClassLoaderUtil.newInstance(classLoader, className);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return null;
    }

    public static <T> T newInstance(ClassLoader classLoaderHint, String className) throws Exception {
        Preconditions.isNotNull(className, "className");
        Class<T> primitiveClass = ClassLoaderUtil.tryPrimitiveClass(className);
        if (primitiveClass != null) {
            return primitiveClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        ClassLoader cl1 = classLoaderHint;
        if (cl1 == null) {
            cl1 = ClassLoaderUtil.class.getClassLoader();
        }
        if (cl1 == null) {
            cl1 = Thread.currentThread().getContextClassLoader();
        }
        ClassLoader cl2 = null;
        if ((className.startsWith(HAZELCAST_BASE_PACKAGE) || className.startsWith(HAZELCAST_ARRAY)) && cl1 != ClassLoaderUtil.class.getClassLoader()) {
            cl2 = ClassLoaderUtil.class.getClassLoader();
        }
        if (cl2 == null) {
            cl2 = Thread.currentThread().getContextClassLoader();
        }
        if (cl1 == cl2) {
            cl2 = null;
        }
        if (cl1 == null && cl2 != null) {
            cl1 = cl2;
            cl2 = null;
        }
        if (cl1 != null) {
            Constructor constructor = CONSTRUCTOR_CACHE.get(cl1, className);
            if (constructor == IRRESOLVABLE_CONSTRUCTOR && cl2 != null) {
                constructor = CONSTRUCTOR_CACHE.get(cl2, className);
            }
            if (constructor != null && constructor != IRRESOLVABLE_CONSTRUCTOR) {
                return constructor.newInstance(new Object[0]);
            }
        }
        try {
            return ClassLoaderUtil.newInstance0(cl1, className);
        }
        catch (ClassNotFoundException e1) {
            if (cl2 != null) {
                CONSTRUCTOR_CACHE.put(cl1, className, IRRESOLVABLE_CONSTRUCTOR);
                try {
                    return ClassLoaderUtil.newInstance0(cl2, className);
                }
                catch (ClassNotFoundException e2) {
                    EmptyStatement.ignore(e2);
                }
            }
            throw e1;
        }
    }

    private static <T> T newInstance0(ClassLoader classLoader, String className) throws Exception {
        Class<Object> klass = classLoader == null ? Class.forName(className) : ClassLoaderUtil.tryLoadClass(className, classLoader);
        return ClassLoaderUtil.newInstance(classLoader, klass);
    }

    public static <T> T newInstance(ClassLoader classLoader, Class klass) throws Exception {
        Constructor constructor = klass.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        if (!ClassLoaderUtil.shouldBypassCache(klass) && classLoader != null) {
            CONSTRUCTOR_CACHE.put(classLoader, klass.getName(), constructor);
        }
        return constructor.newInstance(new Object[0]);
    }

    public static <T> Class<T> loadClass(ClassLoader classLoaderHint, String className) throws ClassNotFoundException {
        ClassLoader contextClassLoader;
        ClassLoader theClassLoader;
        Preconditions.isNotNull(className, "className");
        Class<T> primitiveClass = ClassLoaderUtil.tryPrimitiveClass(className);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        if (classLoaderHint != null) {
            try {
                return ClassLoaderUtil.tryLoadClass(className, classLoaderHint);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((theClassLoader = ClassLoaderUtil.class.getClassLoader()) != null && ClassLoaderUtil.belongsToHazelcastPackage(className)) {
            try {
                return ClassLoaderUtil.tryLoadClass(className, ClassLoaderUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((contextClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return ClassLoaderUtil.tryLoadClass(className, contextClassLoader);
        }
        return ClassLoaderUtil.tryLoadClass(className, NULL_FALLBACK_CLASSLOADER);
    }

    private static boolean belongsToHazelcastPackage(String className) {
        return className.startsWith(HAZELCAST_BASE_PACKAGE) || className.startsWith(HAZELCAST_ARRAY);
    }

    private static <T> Class<T> tryPrimitiveClass(String className) {
        Class primitiveClass;
        if (className.length() <= 7 && Character.isLowerCase(className.charAt(0)) && (primitiveClass = PRIMITIVE_CLASSES_BY_NAME.get(className)) != null) {
            return primitiveClass;
        }
        return null;
    }

    public static boolean isClassAvailable(ClassLoader classLoader, String className) {
        try {
            Class clazz = ClassLoaderUtil.loadClass(classLoader, className);
            return clazz != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> Class<T> tryLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz;
        if (!CLASS_CACHE_DISABLED && (clazz = CLASS_CACHE.get(classLoader, className)) != null) {
            return clazz;
        }
        clazz = classLoader == NULL_FALLBACK_CLASSLOADER ? Class.forName(className) : (className.startsWith("[") ? Class.forName(className, false, classLoader) : classLoader.loadClass(className));
        if (!CLASS_CACHE_DISABLED && !ClassLoaderUtil.shouldBypassCache(clazz)) {
            CLASS_CACHE.put(classLoader, className, clazz);
        }
        return clazz;
    }

    public static boolean isInternalType(Class type) {
        String name = type.getName();
        ClassLoader classLoader = ClassLoaderUtil.class.getClassLoader();
        return type.getClassLoader() == classLoader && name.startsWith(HAZELCAST_BASE_PACKAGE);
    }

    public static Class<?> tryLoadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            return contextClassLoader.loadClass(className);
        }
    }

    public static boolean isClassDefined(String className) {
        try {
            ClassLoaderUtil.tryLoadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean implementsInterfaceWithSameName(Class<?> clazz, Class<?> iface) {
        Class<?>[] interfaces;
        for (Class<?> implementedInterface : interfaces = ClassLoaderUtil.getAllInterfaces(clazz)) {
            if (!implementedInterface.getName().equals(iface.getName())) continue;
            return true;
        }
        return false;
    }

    public static Class<?>[] getAllInterfaces(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        ClassLoaderUtil.addOwnInterfaces(clazz, interfaces);
        ClassLoaderUtil.addInterfacesOfSuperclasses(clazz, interfaces);
        return interfaces.toArray(new Class[0]);
    }

    private static void addOwnInterfaces(Class<?> clazz, Collection<Class<?>> allInterfaces) {
        Class<?>[] interfaces = clazz.getInterfaces();
        Collections.addAll(allInterfaces, interfaces);
        for (Class<?> cl : interfaces) {
            ClassLoaderUtil.addOwnInterfaces(cl, allInterfaces);
        }
    }

    private static void addInterfacesOfSuperclasses(Class<?> clazz, Collection<Class<?>> interfaces) {
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            ClassLoaderUtil.addOwnInterfaces(superClass, interfaces);
        }
    }

    private static boolean shouldBypassCache(Class<?> clazz) {
        return clazz.getClassLoader() instanceof ClassSource || clazz.getClassLoader() instanceof MapResourceClassLoader;
    }

    @Nullable
    public static String extractClassName(String filePath) {
        Matcher matcher = CLASS_PATTERN.matcher(filePath.replace('/', '.'));
        return matcher.matches() ? matcher.group(1) : null;
    }

    static {
        CONSTRUCTOR_CACHE = new ClassLoaderWeakCache();
        CLASS_CACHE = new ClassLoaderWeakCache();
        NULL_FALLBACK_CLASSLOADER = new URLClassLoader(new URL[0], ClassLoaderUtil.class.getClassLoader());
        CLASS_PATTERN = Pattern.compile("(.*)\\.class$");
        try {
            IRRESOLVABLE_CONSTRUCTOR = IrresolvableConstructor.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error("Couldn't initialize irresolvable constructor.", e);
        }
        Stream<Class> primitiveClasses = Stream.of(Boolean.TYPE, Byte.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Void.TYPE);
        PRIMITIVE_CLASSES_BY_NAME = primitiveClasses.collect(Collectors.toUnmodifiableMap(Class::getSimpleName, Function.identity()));
    }

    private static final class ClassLoaderWeakCache<V> {
        private final ConcurrentMap<ClassLoader, ConcurrentMap<String, WeakReference<V>>> cache = new ConcurrentReferenceHashMap<ClassLoader, ConcurrentMap<String, WeakReference<V>>>(16);

        private ClassLoaderWeakCache() {
        }

        private void put(ClassLoader classLoader, String className, V value) {
            ConcurrentMap old;
            ClassLoader cl = classLoader == null ? ClassLoaderUtil.class.getClassLoader() : classLoader;
            ConcurrentMap<String, WeakReference<V>> innerCache = (ConcurrentHashMap<String, WeakReference<V>>)this.cache.get(cl);
            if (innerCache == null && (old = (ConcurrentMap)this.cache.putIfAbsent(cl, innerCache = new ConcurrentHashMap<String, WeakReference<V>>(100))) != null) {
                innerCache = old;
            }
            innerCache.put(className, new WeakReference<V>(value));
        }

        public V get(ClassLoader classloader, String className) {
            V value;
            Preconditions.isNotNull(className, "className");
            ConcurrentMap innerCache = (ConcurrentMap)this.cache.get(classloader);
            if (innerCache == null) {
                return null;
            }
            WeakReference reference = (WeakReference)innerCache.get(className);
            V v = value = reference == null ? null : (V)reference.get();
            if (reference != null && value == null) {
                innerCache.remove(className);
            }
            return value;
        }
    }

    private static final class IrresolvableConstructor {
        public IrresolvableConstructor() {
            throw new UnsupportedOperationException("Irresolvable constructor must never be instantiated.");
        }
    }
}

