/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.invalidation;

import com.hazelcast.internal.nearcache.impl.invalidation.Invalidation;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class BatchNearCacheInvalidation
extends Invalidation {
    private List<Invalidation> invalidations = Collections.emptyList();

    public BatchNearCacheInvalidation() {
    }

    public BatchNearCacheInvalidation(String dataStructureName, List<Invalidation> invalidations) {
        super(dataStructureName);
        this.invalidations = invalidations;
    }

    public List<Invalidation> getInvalidations() {
        return this.invalidations;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        SerializationUtil.writeList(this.invalidations, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.invalidations = SerializationUtil.readList(in);
    }

    @Override
    public String toString() {
        return "BatchNearCacheInvalidation{dataStructureName=" + this.getName() + ", invalidation-count-in-this-batch=" + this.invalidations.size() + "}";
    }

    @Override
    public int getClassId() {
        return 35;
    }
}

