/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.monitor.impl.IndexesStats;
import com.hazelcast.internal.monitor.impl.PartitionPerIndexStats;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import java.lang.invoke.VarHandle;

public class PartitionIndexesStats
implements IndexesStats {
    private static final VarHandle QUERY_COUNT = ReflectionUtil.findVarHandle("queryCount", Long.TYPE);
    private static final VarHandle INDEXED_QUERY_COUNT = ReflectionUtil.findVarHandle("indexedQueryCount", Long.TYPE);
    private static final VarHandle INDEXES_SKIPPED_QUERY_COUNT = ReflectionUtil.findVarHandle("indexesSkippedQueryCount", Long.TYPE);
    private static final VarHandle NO_MATCHING_INDEX_QUERY_COUNT = ReflectionUtil.findVarHandle("noMatchingIndexQueryCount", Long.TYPE);
    private volatile long queryCount;
    private volatile long indexedQueryCount;
    private volatile long indexesSkippedQueryCount;
    private volatile long noMatchingIndexQueryCount;

    @Override
    public long getQueryCount() {
        return this.queryCount;
    }

    @Override
    public void incrementQueryCount() {
        QUERY_COUNT.setOpaque(this, this.queryCount + 1L);
    }

    @Override
    public long getIndexedQueryCount() {
        return this.indexedQueryCount;
    }

    @Override
    public void incrementIndexedQueryCount() {
        INDEXED_QUERY_COUNT.setOpaque(this, this.indexedQueryCount + 1L);
    }

    @Override
    public long getIndexesSkippedQueryCount() {
        return this.indexesSkippedQueryCount;
    }

    @Override
    public void incrementIndexesSkippedQueryCount() {
        INDEXES_SKIPPED_QUERY_COUNT.setOpaque(this, this.indexesSkippedQueryCount + 1L);
    }

    @Override
    public long getNoMatchingIndexQueryCount() {
        return this.noMatchingIndexQueryCount;
    }

    @Override
    public void incrementNoMatchingIndexQueryCount() {
        NO_MATCHING_INDEX_QUERY_COUNT.setOpaque(this, this.noMatchingIndexQueryCount + 1L);
    }

    @Override
    public PerIndexStats createPerIndexStats(boolean ordered, boolean queryableEntriesAreCached) {
        return new PartitionPerIndexStats();
    }
}

