/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.management.dto.ClientEndPointDTO;
import com.hazelcast.internal.management.dto.ClusterHotRestartStatusDTO;
import com.hazelcast.internal.monitor.HotRestartState;
import com.hazelcast.internal.monitor.LocalOperationStats;
import com.hazelcast.internal.monitor.LocalWanStats;
import com.hazelcast.internal.monitor.MemberPartitionState;
import com.hazelcast.internal.monitor.MemberState;
import com.hazelcast.internal.monitor.NodeState;
import com.hazelcast.internal.monitor.impl.HotRestartStateImpl;
import com.hazelcast.internal.monitor.impl.LocalOperationStatsImpl;
import com.hazelcast.internal.monitor.impl.LocalWanStatsImpl;
import com.hazelcast.internal.monitor.impl.MemberPartitionStateImpl;
import com.hazelcast.internal.monitor.impl.NodeStateImpl;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.json.internal.JsonSerializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class MemberStateImpl
implements MemberState {
    private static final String VECTOR_COLLECTIONS = "vectorCollections";
    private String address;
    private UUID uuid;
    private UUID cpMemberUuid;
    private String name;
    private Map<EndpointQualifier, Address> endpoints = Collections.emptyMap();
    private Set<String> mapsWithStats = Collections.emptySet();
    private Set<String> multiMapsWithStats = Collections.emptySet();
    private Set<String> replicatedMapsWithStats = Collections.emptySet();
    private Set<String> queuesWithStats = Collections.emptySet();
    private Set<String> topicsWithStats = Collections.emptySet();
    private Set<String> reliableTopicsWithStats = Collections.emptySet();
    private Set<String> pnCountersWithStats = Collections.emptySet();
    private Set<String> executorsWithStats = Collections.emptySet();
    private Set<String> scheduledExecutorsWithStats = Collections.emptySet();
    private Set<String> durableExecutorsWithStats = Collections.emptySet();
    private Set<String> cachesWithStats = Collections.emptySet();
    private Set<String> flakeIdGeneratorsWithStats = Collections.emptySet();
    private Set<String> userCodeNamespacesWithStats = Collections.emptySet();
    private Set<String> vectorCollections = Collections.emptySet();
    private Collection<ClientEndPointDTO> clients = Collections.emptySet();
    private MemberPartitionState memberPartitionState = new MemberPartitionStateImpl();
    private LocalOperationStats operationStats = new LocalOperationStatsImpl();
    private NodeState nodeState = new NodeStateImpl();
    private HotRestartState hotRestartState = new HotRestartStateImpl();
    private ClusterHotRestartStatusDTO clusterHotRestartStatus = new ClusterHotRestartStatusDTO();
    private final Map<String, LocalWanStats> wanStats = new HashMap<String, LocalWanStats>();

    @Override
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public UUID getCpMemberUuid() {
        return this.cpMemberUuid;
    }

    public void setCpMemberUuid(UUID cpMemberUuid) {
        this.cpMemberUuid = cpMemberUuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<EndpointQualifier, Address> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Map<EndpointQualifier, Address> addressMap) {
        this.endpoints = addressMap;
    }

    public Set<String> getMapsWithStats() {
        return this.mapsWithStats;
    }

    public void setMapsWithStats(Set<String> mapsWithStats) {
        this.mapsWithStats = mapsWithStats;
    }

    public Set<String> getMultiMapsWithStats() {
        return this.multiMapsWithStats;
    }

    public void setMultiMapsWithStats(Set<String> multiMapsWithStats) {
        this.multiMapsWithStats = multiMapsWithStats;
    }

    public Set<String> getReplicatedMapsWithStats() {
        return this.replicatedMapsWithStats;
    }

    public void setReplicatedMapsWithStats(Set<String> replicatedMapsWithStats) {
        this.replicatedMapsWithStats = replicatedMapsWithStats;
    }

    public Set<String> getQueuesWithStats() {
        return this.queuesWithStats;
    }

    public void setQueuesWithStats(Set<String> queuesWithStats) {
        this.queuesWithStats = queuesWithStats;
    }

    public Set<String> getTopicsWithStats() {
        return this.topicsWithStats;
    }

    public void setTopicsWithStats(Set<String> topicsWithStats) {
        this.topicsWithStats = topicsWithStats;
    }

    public Set<String> getReliableTopicsWithStats() {
        return this.reliableTopicsWithStats;
    }

    public void setReliableTopicsWithStats(Set<String> reliableTopicsWithStats) {
        this.reliableTopicsWithStats = reliableTopicsWithStats;
    }

    public Set<String> getPNCountersWithStats() {
        return this.pnCountersWithStats;
    }

    public void setPNCountersWithStats(Set<String> pnCountersWithStats) {
        this.pnCountersWithStats = pnCountersWithStats;
    }

    public Set<String> getExecutorsWithStats() {
        return this.executorsWithStats;
    }

    public void setExecutorsWithStats(Set<String> executorsWithStats) {
        this.executorsWithStats = executorsWithStats;
    }

    public void setScheduledExecutorsWithStats(Set<String> scheduledExecutorsWithStats) {
        this.scheduledExecutorsWithStats = scheduledExecutorsWithStats;
    }

    public void setDurableExecutorsWithStats(Set<String> durableExecutorsWithStats) {
        this.durableExecutorsWithStats = durableExecutorsWithStats;
    }

    public Set<String> getCachesWithStats() {
        return this.cachesWithStats;
    }

    public void setCachesWithStats(Set<String> cachesWithStats) {
        this.cachesWithStats = cachesWithStats;
    }

    public Set<String> getFlakeIdGeneratorsWithStats() {
        return this.flakeIdGeneratorsWithStats;
    }

    public void setFlakeIdGeneratorsWithStats(Set<String> flakeIdGeneratorsWithStats) {
        this.flakeIdGeneratorsWithStats = flakeIdGeneratorsWithStats;
    }

    public Set<String> getUserCodeNamespacesWithStats() {
        return this.userCodeNamespacesWithStats;
    }

    public void setUserCodeNamespacesWithStats(Set<String> userCodeNamespacesWithStats) {
        this.userCodeNamespacesWithStats = userCodeNamespacesWithStats;
    }

    public Set<String> getVectorCollections() {
        return this.vectorCollections;
    }

    public void setVectorCollections(Set<String> vectorCollections) {
        this.vectorCollections = vectorCollections;
    }

    public void putLocalWanStats(String name, LocalWanStats localWanStats) {
        this.wanStats.put(name, localWanStats);
    }

    @Override
    public Collection<ClientEndPointDTO> getClients() {
        return this.clients;
    }

    public void setClients(Collection<ClientEndPointDTO> clients) {
        this.clients = clients;
    }

    @Override
    public LocalOperationStats getOperationStats() {
        return this.operationStats;
    }

    public void setOperationStats(LocalOperationStats operationStats) {
        this.operationStats = operationStats;
    }

    @Override
    public MemberPartitionState getMemberPartitionState() {
        return this.memberPartitionState;
    }

    @Override
    public NodeState getNodeState() {
        return this.nodeState;
    }

    public void setNodeState(NodeState nodeState) {
        this.nodeState = nodeState;
    }

    @Override
    public HotRestartState getHotRestartState() {
        return this.hotRestartState;
    }

    public void setHotRestartState(HotRestartState hotRestartState) {
        this.hotRestartState = hotRestartState;
    }

    @Override
    public ClusterHotRestartStatusDTO getClusterHotRestartStatus() {
        return this.clusterHotRestartStatus;
    }

    public void setClusterHotRestartStatus(ClusterHotRestartStatusDTO clusterHotRestartStatus) {
        this.clusterHotRestartStatus = clusterHotRestartStatus;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("address", this.address);
        String uuidString = this.uuid != null ? this.uuid.toString() : null;
        root.add("uuid", uuidString);
        String cpMemberUuidString = this.cpMemberUuid != null ? this.cpMemberUuid.toString() : null;
        root.add("cpMemberUuid", cpMemberUuidString);
        root.add("name", this.name);
        JsonArray endpoints = new JsonArray();
        for (Map.Entry<EndpointQualifier, Address> entry : this.endpoints.entrySet()) {
            JsonObject address = new JsonObject();
            address.set("host", entry.getValue().getHost());
            address.set("port", entry.getValue().getPort());
            JsonObject endpoint = new JsonObject();
            endpoint.set("protocol", entry.getKey().getType().name());
            endpoint.set("address", address);
            if (entry.getKey().getIdentifier() != null) {
                endpoint.set("id", entry.getKey().getIdentifier());
            }
            endpoints.add(endpoint);
        }
        root.add("endpoints", endpoints);
        MemberStateImpl.serializeAsMap(root, "mapStats", this.mapsWithStats);
        MemberStateImpl.serializeAsMap(root, "multiMapStats", this.multiMapsWithStats);
        MemberStateImpl.serializeAsMap(root, "replicatedMapStats", this.replicatedMapsWithStats);
        MemberStateImpl.serializeAsMap(root, "queueStats", this.queuesWithStats);
        MemberStateImpl.serializeAsMap(root, "topicStats", this.topicsWithStats);
        MemberStateImpl.serializeAsMap(root, "reliableTopicStats", this.reliableTopicsWithStats);
        MemberStateImpl.serializeAsMap(root, "pnCounterStats", this.pnCountersWithStats);
        MemberStateImpl.serializeAsMap(root, "executorStats", this.executorsWithStats);
        MemberStateImpl.serializeAsMap(root, "scheduledExecutorStats", this.scheduledExecutorsWithStats);
        MemberStateImpl.serializeAsMap(root, "durableExecutorStats", this.durableExecutorsWithStats);
        MemberStateImpl.serializeAsMap(root, "cacheStats", this.cachesWithStats);
        MemberStateImpl.serializeAsMap(root, "flakeIdStats", this.flakeIdGeneratorsWithStats);
        MemberStateImpl.serializeMap(root, "wanStats", this.wanStats);
        MemberStateImpl.serializeAsMap(root, "userCodeNamespacesStats", this.userCodeNamespacesWithStats);
        MemberStateImpl.serializeAsMap(root, VECTOR_COLLECTIONS, this.vectorCollections);
        JsonArray clientsArray = new JsonArray();
        for (ClientEndPointDTO client : this.clients) {
            clientsArray.add(client.toJson());
        }
        root.add("clients", clientsArray);
        MemberStateImpl.addJsonIfSerializable(root, "operationStats", this.operationStats);
        root.add("memberPartitionState", this.memberPartitionState.toJson());
        root.add("nodeState", this.nodeState.toJson());
        root.add("hotRestartState", this.hotRestartState.toJson());
        root.add("clusterHotRestartStatus", this.clusterHotRestartStatus.toJson());
        return root;
    }

    private static void serializeMap(JsonObject root, String key, Map<String, ?> map) {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, ?> e : map.entrySet()) {
            MemberStateImpl.addJsonIfSerializable(jsonObject, e.getKey(), e.getValue());
        }
        root.add(key, jsonObject);
    }

    private static void serializeAsMap(JsonObject root, String key, Set<String> set) {
        JsonObject jsonObject = new JsonObject();
        JsonObject stubValue = new JsonObject();
        for (String s : set) {
            jsonObject.add(s, stubValue);
        }
        root.add(key, jsonObject);
    }

    private static void addJsonIfSerializable(JsonObject root, String key, Object value) {
        if (value instanceof JsonSerializable) {
            JsonSerializable serializable = (JsonSerializable)value;
            root.add(key, serializable.toJson());
        }
    }

    private static <T> void putDeserializedIfSerializable(Map<String, T> deserializedValueMap, String key, JsonObject serializedJson, T instance) {
        if (instance instanceof JsonSerializable) {
            JsonSerializable serializable = (JsonSerializable)instance;
            serializable.fromJson(serializedJson);
            deserializedValueMap.put(key, instance);
        }
    }

    private static <T> T readJsonIfDeserializable(JsonObject serializedJson, T instance) {
        if (instance instanceof JsonSerializable) {
            JsonSerializable serializable = (JsonSerializable)instance;
            serializable.fromJson(serializedJson);
        }
        return instance;
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonObject jsonClusterHotRestartStatus;
        JsonObject jsonHotRestartState;
        JsonObject jsonNodeState;
        JsonObject jsonMemberPartitionState;
        this.address = JsonUtil.getString(json, "address");
        String uuidString = JsonUtil.getString(json, "uuid", null);
        this.uuid = uuidString != null ? UUID.fromString(uuidString) : null;
        String cpMemberUuidString = JsonUtil.getString(json, "cpMemberUuid", null);
        this.cpMemberUuid = cpMemberUuidString != null ? UUID.fromString(cpMemberUuidString) : null;
        this.name = JsonUtil.getString(json, "name", null);
        JsonArray jsonEndpoints = JsonUtil.getArray(json, "endpoints");
        this.endpoints = new HashMap<EndpointQualifier, Address>();
        for (JsonValue obj : jsonEndpoints) {
            JsonObject endpoint = obj.asObject();
            String id = endpoint.getString("id", null);
            ProtocolType type = ProtocolType.valueOf(endpoint.getString("protocol", "MEMBER"));
            JsonValue addr = endpoint.get("address");
            String host = addr.asObject().getString("host", "");
            int port = addr.asObject().getInt("port", 0);
            EndpointQualifier qualifier = EndpointQualifier.resolve(type, id);
            Address address = null;
            try {
                address = new Address(host, port);
            }
            catch (UnknownHostException e) {
                EmptyStatement.ignore(e);
            }
            this.endpoints.put(qualifier, address);
        }
        this.mapsWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "mapStats")) {
            this.mapsWithStats.add(((JsonObject.Member)next).getName());
        }
        this.multiMapsWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "multiMapStats")) {
            this.multiMapsWithStats.add(((JsonObject.Member)next).getName());
        }
        this.replicatedMapsWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "replicatedMapStats")) {
            this.replicatedMapsWithStats.add(((JsonObject.Member)next).getName());
        }
        this.queuesWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "queueStats")) {
            this.queuesWithStats.add(((JsonObject.Member)next).getName());
        }
        this.topicsWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "topicStats")) {
            this.topicsWithStats.add(((JsonObject.Member)next).getName());
        }
        this.reliableTopicsWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "reliableTopicStats")) {
            this.reliableTopicsWithStats.add(((JsonObject.Member)next).getName());
        }
        this.pnCountersWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "pnCounterStats")) {
            this.pnCountersWithStats.add(((JsonObject.Member)next).getName());
        }
        this.executorsWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "executorStats")) {
            this.executorsWithStats.add(((JsonObject.Member)next).getName());
        }
        this.scheduledExecutorsWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "scheduledExecutorStats")) {
            this.scheduledExecutorsWithStats.add(((JsonObject.Member)next).getName());
        }
        this.durableExecutorsWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "durableExecutorStats")) {
            this.durableExecutorsWithStats.add(((JsonObject.Member)next).getName());
        }
        this.cachesWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "cacheStats")) {
            this.cachesWithStats.add(((JsonObject.Member)next).getName());
        }
        this.flakeIdGeneratorsWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "flakeIdStats")) {
            this.flakeIdGeneratorsWithStats.add(((JsonObject.Member)next).getName());
        }
        this.userCodeNamespacesWithStats = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, "userCodeNamespacesStats")) {
            this.userCodeNamespacesWithStats.add(((JsonObject.Member)next).getName());
        }
        this.vectorCollections = new HashSet<String>();
        for (Object next : JsonUtil.getObject(json, VECTOR_COLLECTIONS)) {
            this.vectorCollections.add(((JsonObject.Member)next).getName());
        }
        for (Object next : JsonUtil.getObject(json, "wanStats", new JsonObject())) {
            MemberStateImpl.putDeserializedIfSerializable(this.wanStats, ((JsonObject.Member)next).getName(), ((JsonObject.Member)next).getValue().asObject(), new LocalWanStatsImpl());
        }
        JsonArray jsonClients = JsonUtil.getArray(json, "clients");
        this.clients = new ArrayList<ClientEndPointDTO>();
        for (JsonValue jsonClient : jsonClients) {
            ClientEndPointDTO client = new ClientEndPointDTO();
            client.fromJson(jsonClient.asObject());
            this.clients.add(client);
        }
        JsonObject jsonOperationStats = JsonUtil.getObject(json, "operationStats", null);
        if (jsonOperationStats != null) {
            this.operationStats = MemberStateImpl.readJsonIfDeserializable(jsonOperationStats, this.operationStats);
        }
        if ((jsonMemberPartitionState = JsonUtil.getObject(json, "memberPartitionState", null)) != null) {
            this.memberPartitionState = new MemberPartitionStateImpl();
            this.memberPartitionState.fromJson(jsonMemberPartitionState);
        }
        if ((jsonNodeState = JsonUtil.getObject(json, "nodeState", null)) != null) {
            this.nodeState = new NodeStateImpl();
            this.nodeState.fromJson(jsonNodeState);
        }
        if ((jsonHotRestartState = JsonUtil.getObject(json, "hotRestartState", null)) != null) {
            this.hotRestartState = new HotRestartStateImpl();
            this.hotRestartState.fromJson(jsonHotRestartState);
        }
        if ((jsonClusterHotRestartStatus = JsonUtil.getObject(json, "clusterHotRestartStatus", null)) != null) {
            this.clusterHotRestartStatus = new ClusterHotRestartStatusDTO();
            this.clusterHotRestartStatus.fromJson(jsonClusterHotRestartStatus);
        }
    }

    public String toString() {
        return "MemberStateImpl{address=" + this.address + ", uuid=" + String.valueOf(this.uuid) + ", cpMemberUuid=" + String.valueOf(this.cpMemberUuid) + ", name=" + this.name + ", clients=" + String.valueOf(this.clients) + ", mapsWithStats=" + String.valueOf(this.mapsWithStats) + ", multiMapsWithStats=" + String.valueOf(this.multiMapsWithStats) + ", replicatedMapsWithStats=" + String.valueOf(this.replicatedMapsWithStats) + ", queuesWithStats=" + String.valueOf(this.queuesWithStats) + ", topicsWithStats=" + String.valueOf(this.topicsWithStats) + ", reliableTopicsWithStats=" + String.valueOf(this.reliableTopicsWithStats) + ", pnCountersWithStats=" + String.valueOf(this.pnCountersWithStats) + ", executorStats=" + String.valueOf(this.executorsWithStats) + ", scheduledExecutorStats=" + String.valueOf(this.scheduledExecutorsWithStats) + ", durableExecutorStats=" + String.valueOf(this.durableExecutorsWithStats) + ", cachesWithStats=" + String.valueOf(this.cachesWithStats) + ", flakeIdGeneratorsWithStats=" + String.valueOf(this.flakeIdGeneratorsWithStats) + ", userCodeNamespacesWithStats=" + String.valueOf(this.userCodeNamespacesWithStats) + ", vectorCollections=" + String.valueOf(this.vectorCollections) + ", wanStats=" + String.valueOf(this.wanStats) + ", operationStats=" + String.valueOf(this.operationStats) + ", memberPartitionState=" + String.valueOf(this.memberPartitionState) + ", nodeState=" + String.valueOf(this.nodeState) + ", hotRestartState=" + String.valueOf(this.hotRestartState) + ", clusterHotRestartStatus=" + String.valueOf(this.clusterHotRestartStatus) + "}";
    }
}

