/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.managementcenter;

import com.hazelcast.internal.metrics.impl.MetricsService;
import com.hazelcast.internal.metrics.managementcenter.ConcurrentArrayRingbuffer;
import com.hazelcast.internal.metrics.managementcenter.MetricsDataSerializerHook;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.spi.impl.operationservice.SelfResponseOperation;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ReadMetricsOperation
extends Operation
implements ReadonlyOperation,
IdentifiedDataSerializable,
SelfResponseOperation {
    private long offset;

    public ReadMetricsOperation() {
    }

    public ReadMetricsOperation(long offset) {
        this.offset = offset;
    }

    @Override
    public void beforeRun() {
        MetricsService service = (MetricsService)this.getService();
        service.getLiveOperationRegistry().register(this);
    }

    @Override
    public void run() {
        ILogger logger = this.getNodeEngine().getLogger(this.getClass());
        MetricsService service = (MetricsService)this.getService();
        CompletableFuture<ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>>> future = service.readMetrics(this.offset);
        future.whenCompleteAsync(ExceptionUtil.withTryCatch(logger, (slice, error) -> this.doSendResponse(error != null ? ExceptionUtil.peel(error) : slice)), ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:metricsService";
    }

    private void doSendResponse(Object value) {
        try {
            this.sendResponse(value);
        }
        finally {
            MetricsService service = (MetricsService)this.getService();
            service.getLiveOperationRegistry().deregister(this);
        }
    }

    @Override
    public int getFactoryId() {
        return MetricsDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.offset);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.offset = in.readLong();
    }
}

