/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.managementcenter;

import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.MetricsPublisher;
import com.hazelcast.internal.metrics.impl.LongWordException;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nonnull;

public class ManagementCenterPublisher
implements MetricsPublisher {
    private final ILogger logger;
    private final ObjLongConsumer<byte[]> consumer;
    private final MetricsCompressor compressor;
    private final AtomicBoolean longWordLogged = new AtomicBoolean();

    public ManagementCenterPublisher(@Nonnull LoggingService loggingService, @Nonnull ObjLongConsumer<byte[]> writeFn) {
        this.consumer = writeFn;
        this.logger = loggingService.getLogger(this.getClass());
        this.compressor = new MetricsCompressor();
    }

    @Override
    public String name() {
        return "Management Center Publisher";
    }

    @Override
    public void publishLong(MetricDescriptor descriptor, long value) {
        try {
            if (descriptor.isTargetIncluded(MetricTarget.MANAGEMENT_CENTER)) {
                this.compressor.addLong(descriptor, value);
            }
        }
        catch (LongWordException e) {
            this.logLongWordException(e);
        }
    }

    @Override
    public void publishDouble(MetricDescriptor descriptor, double value) {
        try {
            if (descriptor.isTargetIncluded(MetricTarget.MANAGEMENT_CENTER)) {
                this.compressor.addDouble(descriptor, value);
            }
        }
        catch (LongWordException e) {
            this.logLongWordException(e);
        }
    }

    private void logLongWordException(LongWordException e) {
        if (this.longWordLogged.compareAndSet(false, true)) {
            this.logger.warning(e.getMessage());
        } else {
            this.logger.fine(e.getMessage());
        }
    }

    @Override
    public void whenComplete() {
        int count = this.compressor.count();
        byte[] blob = this.compressor.getBlobAndReset();
        this.consumer.accept(blob, System.currentTimeMillis());
        this.logger.finest("Collected %,d metrics, %,d bytes", count, blob.length);
    }

    public int getCount() {
        return this.compressor.count();
    }
}

