/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management;

import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.ClientSelector;
import com.hazelcast.client.impl.ClientSelectors;
import com.hazelcast.internal.management.dto.ClientBwListDTO;
import com.hazelcast.internal.management.dto.ClientBwListEntryDTO;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class ClientBwListConfigHandler {
    private final ClientEngine clientEngine;

    public ClientBwListConfigHandler(ClientEngine clientEngine) {
        this.clientEngine = clientEngine;
    }

    public void applyConfig(ClientBwListDTO configDTO) {
        Objects.requireNonNull(configDTO, "Client filtering config must not be null");
        Objects.requireNonNull(configDTO.mode, "Config mode must not be null");
        Objects.requireNonNull(configDTO.entries, "Config entries must not be null");
        this.clientEngine.applySelector(switch (configDTO.mode) {
            case ClientBwListDTO.Mode.DISABLED -> ClientSelectors.any();
            case ClientBwListDTO.Mode.WHITELIST -> ClientBwListConfigHandler.createSelector(configDTO.entries);
            case ClientBwListDTO.Mode.BLACKLIST -> ClientSelectors.inverse(ClientBwListConfigHandler.createSelector(configDTO.entries));
            default -> throw new IllegalArgumentException("Unknown client B/W list mode: " + String.valueOf((Object)configDTO.mode));
        });
    }

    private static ClientSelector createSelector(List<ClientBwListEntryDTO> entries) {
        ClientSelector selector = ClientSelectors.none();
        for (ClientBwListEntryDTO entryDTO : entries) {
            ClientSelector entrySelector = ClientBwListConfigHandler.createSelector(entryDTO);
            selector = ClientSelectors.or(selector, entrySelector);
        }
        return selector;
    }

    private static ClientSelector createSelector(ClientBwListEntryDTO entry) {
        Objects.requireNonNull(entry.type, "Entry type must not be null");
        Objects.requireNonNull(entry.value, "Entry value must not be null");
        switch (entry.type) {
            case IP_ADDRESS: {
                return ClientSelectors.ipSelector(entry.value);
            }
            case INSTANCE_NAME: {
                return ClientSelectors.nameSelector(ClientBwListConfigHandler.sanitizeValueWithWildcards(entry.value));
            }
            case LABEL: {
                return ClientSelectors.labelSelector(ClientBwListConfigHandler.sanitizeValueWithWildcards(entry.value));
            }
        }
        throw new IllegalArgumentException("Unknown client B/W list entry type: " + String.valueOf((Object)entry.type));
    }

    private static String sanitizeValueWithWildcards(String value) {
        String quoted = Pattern.quote(value);
        return quoted.replaceAll("\\*", "\\\\E.*\\\\Q");
    }
}

