/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.util.concurrent.ConcurrentItemCounter;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.NamedOperation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class OperationThreadSamplerPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.operationthreadsamples.period.seconds", 0, TimeUnit.SECONDS);
    public static final HazelcastProperty SAMPLER_PERIOD_MILLIS = new HazelcastProperty("hazelcast.diagnostics.operationthreadsamples.sampler.period.millis", 100, TimeUnit.MILLISECONDS);
    public static final HazelcastProperty INCLUDE_NAME = new HazelcastProperty("hazelcast.diagnostics.operationthreadsamples.includeName", false);
    public static final float HUNDRED = 100.0f;
    protected final ConcurrentItemCounter<String> partitionSpecificSamples = new ConcurrentItemCounter();
    protected final ConcurrentItemCounter<String> genericSamples = new ConcurrentItemCounter();
    protected final OperationExecutor executor;
    protected final NodeEngineImpl nodeEngine;
    private boolean includeName;
    private long samplerPeriodMillis;
    private long periodMillis;
    private SampleThread sampleThread;

    public OperationThreadSamplerPlugin(NodeEngineImpl nodeEngine) {
        super(nodeEngine.getLogger(OperationThreadSamplerPlugin.class));
        this.nodeEngine = nodeEngine;
        OperationServiceImpl operationService = nodeEngine.getOperationService();
        this.executor = operationService.getOperationExecutor();
        this.readProperties();
    }

    @Override
    void readProperties() {
        this.periodMillis = this.nodeEngine.getProperties().getMillis(this.overrideProperty(PERIOD_SECONDS));
        this.samplerPeriodMillis = this.nodeEngine.getProperties().getMillis(this.overrideProperty(SAMPLER_PERIOD_MILLIS));
        this.includeName = this.nodeEngine.getProperties().getBoolean(this.overrideProperty(INCLUDE_NAME));
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.logger.info("Plugin:active: period-millis:" + this.periodMillis + " sampler-period-millis:" + this.samplerPeriodMillis);
        this.sampleThread = new SampleThread();
        this.sampleThread.start();
    }

    @Override
    public void onShutdown() {
        this.sampleThread.interrupt();
        super.onShutdown();
        this.logger.info("Plugin:inactive");
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        if (!this.isActive()) {
            return;
        }
        writer.startSection("OperationThreadSamples");
        this.write(writer, "Partition", this.partitionSpecificSamples);
        this.write(writer, "Generic", this.genericSamples);
        writer.endSection();
    }

    private void write(DiagnosticsLogWriter writer, String text, ConcurrentItemCounter<String> samples) {
        writer.startSection(text);
        long total = samples.total();
        for (String name : samples.keySet()) {
            long s = samples.get(name);
            String entryStr = total == 0L ? String.valueOf(s) : s + " " + 100.0f * (float)s / (float)total + "%";
            writer.writeKeyValueEntry(name, entryStr);
        }
        writer.endSection();
    }

    boolean getIncludeName() {
        return this.includeName;
    }

    long getSamplerPeriodMillis() {
        return this.samplerPeriodMillis;
    }

    protected class SampleThread
    extends Thread {
        protected SampleThread() {
        }

        @Override
        public void run() {
            long nextRunMillis = System.currentTimeMillis();
            while (OperationThreadSamplerPlugin.this.nodeEngine.isRunning() && !Thread.currentThread().isInterrupted()) {
                LockSupport.parkUntil(nextRunMillis);
                nextRunMillis = OperationThreadSamplerPlugin.this.samplerPeriodMillis;
                this.sample(OperationThreadSamplerPlugin.this.executor.getPartitionOperationRunners(), OperationThreadSamplerPlugin.this.partitionSpecificSamples);
                this.sample(OperationThreadSamplerPlugin.this.executor.getGenericOperationRunners(), OperationThreadSamplerPlugin.this.genericSamples);
            }
        }

        private void sample(OperationRunner[] runners, ConcurrentItemCounter<String> samples) {
            for (OperationRunner runner : runners) {
                Object task = runner.currentTask();
                if (task == null) continue;
                samples.inc(this.toKey(task));
            }
        }

        private String toKey(Object task) {
            Object name;
            if (OperationThreadSamplerPlugin.this.includeName) {
                if (task instanceof NamedOperation) {
                    NamedOperation operation = (NamedOperation)task;
                    name = task.getClass().getName() + "#" + operation.getName();
                } else {
                    name = task.getClass().getName();
                }
            } else {
                name = task.getClass().getName();
            }
            return name;
        }
    }
}

