/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.DiagnosticsLog;
import com.hazelcast.internal.diagnostics.DiagnosticsLogWriterImpl;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.logging.ILogger;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;

final class DiagnosticsStdout
implements DiagnosticsLog {
    private final Diagnostics diagnostics;
    private final ILogger logger;
    private final DiagnosticsLogWriterImpl logWriter;
    private final PrintWriter printWriter;
    private boolean staticPluginsRendered;

    DiagnosticsStdout(Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
        this.logger = diagnostics.logger;
        this.logWriter = new DiagnosticsLogWriterImpl(diagnostics.isIncludeEpochTime(), diagnostics.logger);
        this.printWriter = this.newWriter();
        this.logWriter.init(this.printWriter);
        this.logger.info("Sending diagnostics logs to the stdout");
    }

    @Override
    public void write(DiagnosticsPlugin plugin) {
        try {
            if (!this.staticPluginsRendered) {
                this.renderStaticPlugins();
                this.staticPluginsRendered = true;
            }
            this.renderPlugin(plugin);
            this.printWriter.flush();
        }
        catch (RuntimeException e) {
            this.logger.warning("Failed to write stdout: ", e);
        }
    }

    @Override
    public void close() {
        this.printWriter.flush();
    }

    private void renderStaticPlugins() {
        for (DiagnosticsPlugin plugin : this.diagnostics.staticTasks.get()) {
            this.renderPlugin(plugin);
        }
    }

    private void renderPlugin(DiagnosticsPlugin plugin) {
        this.logWriter.resetSectionLevel();
        plugin.run(this.logWriter);
    }

    private PrintWriter newWriter() {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, encoder), Short.MAX_VALUE));
    }
}

