/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.DiagnosticsLog;
import com.hazelcast.internal.diagnostics.DiagnosticsLogWriterImpl;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.logging.ILogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;

final class DiagnosticsLogFile
implements DiagnosticsLog {
    private static final int ONE_MB = 0x100000;
    volatile File file;
    private final Diagnostics diagnostics;
    private final ILogger logger;
    private final String fileName;
    private final DiagnosticsLogWriterImpl logWriter;
    private int index;
    private PrintWriter printWriter;
    private final int maxRollingFileCount;
    private final int maxRollingFileSizeBytes;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private Object lock = new Object();

    DiagnosticsLogFile(Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
        this.logger = diagnostics.logger;
        this.fileName = diagnostics.getFileName() + "-%03d.log";
        this.logWriter = new DiagnosticsLogWriterImpl(diagnostics.isIncludeEpochTime(), diagnostics.logger);
        this.createDirectoryIfDoesNotExist();
        this.maxRollingFileCount = diagnostics.getMaxRollingFileCount();
        this.maxRollingFileSizeBytes = Math.round(1048576.0f * diagnostics.getMaxRollingFileSizeMB());
        this.logger.finest("maxRollingFileSizeBytes:%s maxRollingFileCount:%s", this.maxRollingFileSizeBytes, this.maxRollingFileCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DiagnosticsPlugin plugin) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed.compareAndSet(false, false)) {
                return;
            }
            try {
                if (this.file == null) {
                    this.file = this.newFile(this.index, false);
                    this.printWriter = this.newWriter();
                    this.renderStaticPlugins();
                }
                this.renderPlugin(plugin);
                this.printWriter.flush();
                if (this.file.length() >= (long)this.maxRollingFileSizeBytes) {
                    this.rollover();
                }
            }
            catch (IOException e) {
                this.logger.warning("Failed to write to file:" + this.file.getAbsolutePath(), e);
                this.close();
            }
            catch (RuntimeException e) {
                this.logger.warning("Failed to write file: " + String.valueOf(this.file), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            IOUtil.closeResource(this.printWriter);
        }
    }

    int getMaxRollingFileCount() {
        return this.maxRollingFileCount;
    }

    int getMaxRollingFileSizeBytes() {
        return this.maxRollingFileSizeBytes;
    }

    private File newFile(int index, boolean silent) {
        this.createDirectoryIfDoesNotExist();
        if (!silent && index == 0) {
            this.logger.info("Diagnostics log directory is [" + String.valueOf(this.diagnostics.getLoggingDirectory()) + "]");
        }
        return new File(this.diagnostics.getLoggingDirectory(), String.format(this.fileName, index));
    }

    private void createDirectoryIfDoesNotExist() {
        File dir = this.diagnostics.getLoggingDirectory();
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new InvalidConfigurationException("Configured path for diagnostics log file '" + String.valueOf(dir) + "' exists, but it's not a directory");
            }
            if (!this.canWriteToDirectory(dir)) {
                throw new InvalidConfigurationException("Cannot write to diagnostics log directory '" + String.valueOf(dir) + "'. Check filesystem permissions.");
            }
        } else if (!dir.mkdirs()) {
            throw new InvalidConfigurationException("Error while creating a directory '" + String.valueOf(dir) + "' for diagnostics log files. Check filesystem permissions.");
        }
    }

    private void renderStaticPlugins() {
        for (DiagnosticsPlugin plugin : this.diagnostics.staticTasks.get()) {
            this.renderPlugin(plugin);
        }
    }

    private void renderPlugin(DiagnosticsPlugin plugin) {
        this.logWriter.resetSectionLevel();
        this.logWriter.init(this.printWriter);
        plugin.run(this.logWriter);
    }

    private PrintWriter newWriter() throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(this.file, true);
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, encoder), Short.MAX_VALUE));
    }

    private void rollover() {
        IOUtil.closeResource(this.printWriter);
        this.printWriter = null;
        this.file = null;
        File file = this.newFile(this.index - this.maxRollingFileCount, true);
        IOUtil.deleteQuietly(file);
        ++this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canWriteToDirectory(File dir) {
        if (!dir.isDirectory() || !dir.canWrite()) {
            return false;
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("writetest", ".tmp", dir);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
    }
}

