/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.auditlog.AuditlogService;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.diagnostics.DiagnosticsConfig;
import com.hazelcast.internal.diagnostics.DiagnosticsLog;
import com.hazelcast.internal.diagnostics.DiagnosticsLogFile;
import com.hazelcast.internal.diagnostics.DiagnosticsLogger;
import com.hazelcast.internal.diagnostics.DiagnosticsMetricCollector;
import com.hazelcast.internal.diagnostics.DiagnosticsOutputType;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.diagnostics.DiagnosticsStdout;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.management.events.DiagnosticsConfigUpdatedEvent;
import com.hazelcast.internal.namespace.impl.NodeEngineThreadLocalContext;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.File;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Diagnostics {
    public static final HazelcastProperty ENABLED = new HazelcastProperty("hazelcast.diagnostics.enabled", false);
    public static final HazelcastProperty MAX_ROLLED_FILE_SIZE_MB = new HazelcastProperty("hazelcast.diagnostics.max.rolled.file.size.mb", 50);
    public static final HazelcastProperty MAX_ROLLED_FILE_COUNT = new HazelcastProperty("hazelcast.diagnostics.max.rolled.file.count", 10);
    public static final HazelcastProperty INCLUDE_EPOCH_TIME = new HazelcastProperty("hazelcast.diagnostics.include.epoch", true);
    public static final HazelcastProperty DIRECTORY = new HazelcastProperty("hazelcast.diagnostics.directory", System.getProperty("user.dir"));
    public static final HazelcastProperty FILENAME_PREFIX = new HazelcastProperty("hazelcast.diagnostics.filename.prefix");
    public static final HazelcastProperty OUTPUT_TYPE = new HazelcastProperty("hazelcast.diagnostics.stdout", DiagnosticsOutputType.FILE);
    public static final int SERVICE_SHUTDOWN = -1;
    public static final int SERVICE_DISABLED = 0;
    public static final int SERVICE_ENABLED = 1;
    public static final int SERVICE_RESTARTING = 2;
    public static final long TERMINATE_TIMEOUT_SECONDS = 30L;
    public static final String DIAGNOSTIC_PROPERTY_PREFIX = "hazelcast.diagnostics.";
    static final int AUTO_OFF_BACKOFF_SECONDS = 5;
    final AtomicReference<DiagnosticsPlugin[]> staticTasks = new AtomicReference<DiagnosticsPlugin[]>(new DiagnosticsPlugin[0]);
    final ILogger logger;
    final LoggingService loggingService;
    final String hzName;
    TimeUnit autoOffDurationUnit = TimeUnit.MINUTES;
    HazelcastProperties hazelcastProperties;
    DiagnosticsLog diagnosticsLog;
    private final Map<Class<? extends DiagnosticsPlugin>, DiagnosticsPlugin> pluginsMap = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<DiagnosticsPlugin, ScheduledFuture<?>> pluginsFutureMap = new ConcurrentHashMap();
    private final AtomicInteger status = new AtomicInteger();
    private final String baseFileName;
    private String baseFileNameWithTime;
    private DiagnosticsOutputType outputType;
    private DiagnosticsConfig config = new DiagnosticsConfig();
    private File loggingDirectory = new File(DIRECTORY.getDefaultValue());
    private String filePrefix;
    private boolean includeEpochTime;
    private float maxRollingFileSizeMB;
    private int maxRollingFileCount;
    private ScheduledExecutorService scheduler;
    private ScheduledExecutorService autoOffScheduler;
    private ScheduledFuture<?> autoOffFuture;
    private final Object lifecycleLock = new Object();
    private final AuditlogService auditlogService;
    private NodeEngine nodeEngine;
    private final DiagnosticsMetricCollector metricCollector = new DiagnosticsMetricCollector();

    public Diagnostics(String baseFileName, LoggingService loggingService, String hzName, HazelcastProperties properties) {
        this(baseFileName, loggingService, hzName, properties, null);
    }

    public Diagnostics(String baseFileName, LoggingService loggingService, String hzName, HazelcastProperties properties, NodeEngine nodeEngine) {
        this.logger = loggingService.getLogger(Diagnostics.class);
        this.loggingService = loggingService;
        this.hzName = hzName;
        this.hazelcastProperties = properties;
        this.baseFileName = baseFileName;
        this.auditlogService = nodeEngine != null ? nodeEngine.getNode().getNodeExtension().getAuditlogService() : null;
        this.nodeEngine = nodeEngine;
        this.setConfig0(this.config);
    }

    public String getBaseFileNameWithTime() {
        return this.baseFileNameWithTime != null ? this.baseFileNameWithTime : this.baseFileName;
    }

    public String getFileName() {
        return this.filePrefix == null ? this.getBaseFileNameWithTime() : this.filePrefix + "-" + this.getBaseFileNameWithTime();
    }

    public File getLoggingDirectory() {
        return this.loggingDirectory;
    }

    public boolean isEnabled() {
        return this.status.get() == 1;
    }

    public boolean isIncludeEpochTime() {
        return this.includeEpochTime;
    }

    public float getMaxRollingFileSizeMB() {
        return this.maxRollingFileSizeMB;
    }

    public int getMaxRollingFileCount() {
        return this.maxRollingFileCount;
    }

    public DiagnosticsMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    public File currentFile() throws UnsupportedOperationException {
        if (this.outputType != DiagnosticsOutputType.FILE) {
            throw new UnsupportedOperationException();
        }
        return ((DiagnosticsLogFile)this.diagnosticsLog).file;
    }

    public <P extends DiagnosticsPlugin> P getPlugin(Class<P> pluginClass) {
        if (this.isEnabled()) {
            return (P)this.pluginsMap.get(pluginClass);
        }
        return null;
    }

    public void register(DiagnosticsPlugin plugin) {
        Preconditions.checkNotNull(plugin, "plugin can't be null");
        plugin.setProperties(this.config.getPluginProperties());
        long periodMillis = plugin.getPeriodMillis();
        if (periodMillis < -1L) {
            throw new IllegalArgumentException(String.valueOf(plugin) + " can't return a periodMillis smaller than -1");
        }
        if (this.isDynamicallyManagedPlugin(periodMillis, plugin)) {
            this.pluginsMap.put(plugin.getClass(), plugin);
            this.cancelAutoOffFuture("Reason: A non-dynamic plugin " + String.valueOf(plugin.getClass()) + " registered.");
        } else if (plugin.canBeEnabledDynamically()) {
            this.pluginsMap.put(plugin.getClass(), plugin);
        }
        this.logger.finest(String.valueOf(plugin.getClass()) + " is " + (periodMillis == 0L ? "disabled" : "enabled"));
        if (periodMillis == 0L) {
            return;
        }
        if (this.status.get() == 0) {
            return;
        }
        this.schedulePlugin0(plugin, periodMillis);
    }

    private void schedulePlugin0(DiagnosticsPlugin plugin, long periodMillis) {
        try {
            plugin.onStart();
        }
        catch (Throwable t) {
            this.logger.warning("Diagnostics plugin failed to start: " + String.valueOf(plugin), t);
            return;
        }
        if (periodMillis > 0L) {
            ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(new WritePluginTask(plugin), 0L, periodMillis, TimeUnit.MILLISECONDS);
            this.pluginsFutureMap.put(plugin, future);
        } else {
            this.addStaticPlugin(plugin);
        }
    }

    private boolean isDynamicallyManagedPlugin(long periodMillis, DiagnosticsPlugin plugin) {
        return !plugin.canBeEnabledDynamically() && periodMillis > 0L && !this.pluginsMap.containsKey(plugin.getClass()) && this.isEnabled();
    }

    private void addStaticPlugin(DiagnosticsPlugin plugin) {
        DiagnosticsPlugin[] newPlugins;
        DiagnosticsPlugin[] oldPlugins;
        do {
            oldPlugins = this.staticTasks.get();
            newPlugins = new DiagnosticsPlugin[oldPlugins.length + 1];
            System.arraycopy(oldPlugins, 0, newPlugins, 0, oldPlugins.length);
            newPlugins[oldPlugins.length] = plugin;
        } while (!this.staticTasks.compareAndSet(oldPlugins, newPlugins));
    }

    public void start() {
        if (this.status.get() == 0) {
            if (this.isConfiguredStatically()) {
                this.logger.info("Diagnostics service is disabled statically. You cannot start it at runtime dynamically. In order to enable it, you need to set property `hazelcast.diagnostics.enabled=true` or remove this property usage for dynamic enablement.");
            } else {
                this.logger.info("Diagnostics service is disabled. You can enable it over Management Center or Operator dynamically.");
            }
            return;
        }
        long startedTime = System.currentTimeMillis();
        this.baseFileNameWithTime = this.baseFileName + "-" + startedTime;
        Instant startedTimeInstant = Instant.ofEpochMilli(startedTime);
        this.diagnosticsLog = Diagnostics.newLog(this);
        String message = String.format("Diagnostics started at [%s]-[%s] with configuration %s", startedTime, startedTimeInstant.atZone(ZoneOffset.UTC), this.config);
        this.logger.info(message);
        if (this.auditlogService != null) {
            this.auditlogService.eventBuilder("HZ-0801").message(message).addParameter("DiagnosticsConfig", this.config).log();
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new DiagnosticSchedulerThreadFactory("DiagnosticsSchedulerThread"));
        this.scheduleAutoOff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(DiagnosticsConfig diagnosticsConfig) {
        Object object = this.lifecycleLock;
        synchronized (object) {
            int currentStatus = this.status.get();
            if (currentStatus == -1) {
                return;
            }
            if (this.isConfiguredStatically()) {
                String msg = "Diagnostics service is configured statically. You cannot set a configuration at runtime.";
                throw new IllegalStateException(msg);
            }
            if (currentStatus == 2) {
                String msg = "Diagnostics service is restarting already. You can't set a configuration at this stage.";
                throw new IllegalStateException(msg);
            }
            if (diagnosticsConfig.isEnabled() && currentStatus == 1) {
                this.status.set(2);
                String message = "Diagnostics is going to restart with new configuration.";
                this.logger.info(message);
                if (this.auditlogService != null) {
                    this.auditlogService.eventBuilder("HZ-0803").message(message).addParameter("DiagnosticsConfig", diagnosticsConfig).log();
                }
            } else {
                this.status.set(0);
            }
            this.cancelRunningPlugins();
            this.closeScheduler();
            this.closeLog();
            this.setConfig0(diagnosticsConfig);
            if (this.status.get() == 0) {
                this.logger.info("Diagnostics disabled. To enable, set over Management Center or Operator.");
                if (this.auditlogService != null) {
                    this.auditlogService.eventBuilder("HZ-0802").message("Diagnostics disabled").addParameter("DiagnosticsConfig", this.config).log();
                }
                this.cancelAutoOffFuture("Reason: Diagnostics service is disabled.");
                this.emitMCConfigUpdatedEvent();
                return;
            }
            this.startOrFail(diagnosticsConfig);
            this.emitMCConfigUpdatedEvent();
            this.scheduleRegisteredPlugins();
        }
    }

    private void startOrFail(DiagnosticsConfig diagnosticsConfig) {
        try {
            this.start();
            this.scheduleRegisteredPlugins();
            this.metricCollector.incrementDynamicallyEnabledCount();
        }
        catch (InvalidConfigurationException t) {
            this.logger.warning("Diagnostics service cannot be started with the provided configuration: " + String.valueOf(diagnosticsConfig), t);
            this.status.set(0);
            this.config.setEnabled(false);
            if (this.auditlogService != null) {
                this.auditlogService.eventBuilder("HZ-0802").message("Diagnostics disabled due to invalid configuration").addParameter("DiagnosticsConfig", this.config).log();
            }
            throw t;
        }
    }

    public boolean isConfiguredStatically() {
        return this.hazelcastProperties.containsKey(ENABLED);
    }

    public DiagnosticsConfig getDiagnosticsConfig() {
        return this.config;
    }

    private String getNameOfNonDynamicPlugins() {
        String nameOfNonDynamicPlugins = this.pluginsMap.entrySet().stream().filter(entry -> !((DiagnosticsPlugin)entry.getValue()).canBeEnabledDynamically()).map(entry -> ((Class)entry.getKey()).getName()).reduce((first, second) -> first + ", " + second).orElse("none");
        return nameOfNonDynamicPlugins;
    }

    private boolean isNonDynamicPluginExist() {
        for (DiagnosticsPlugin plugin : this.pluginsMap.values()) {
            if (plugin.canBeEnabledDynamically()) continue;
            return true;
        }
        return false;
    }

    private void closeScheduler() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.scheduler.shutdownNow();
                this.logger.fine("Diagnostics scheduler was interrupted while shutting down.", e);
            }
            finally {
                this.scheduler = null;
            }
        }
        if (this.autoOffScheduler != null) {
            this.autoOffScheduler.shutdownNow();
        }
    }

    private void closeLog() {
        if (this.diagnosticsLog != null) {
            this.diagnosticsLog.close();
        }
    }

    public static DiagnosticsLog newLog(Diagnostics diagnostics) {
        return switch (diagnostics.outputType) {
            default -> throw new IncompatibleClassChangeError();
            case DiagnosticsOutputType.FILE -> new DiagnosticsLogFile(diagnostics);
            case DiagnosticsOutputType.STDOUT -> new DiagnosticsStdout(diagnostics);
            case DiagnosticsOutputType.LOGGER -> new DiagnosticsLogger(diagnostics);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.status.get() == -1) {
                return;
            }
            this.status.set(-1);
            this.cancelRunningPlugins();
            this.closeScheduler();
            this.closeLog();
        }
    }

    ScheduledFuture<?> getFutureOf(Class<? extends DiagnosticsPlugin> pluginType) {
        if (this.pluginsMap.containsKey(pluginType)) {
            DiagnosticsPlugin plugin = this.pluginsMap.get(pluginType);
            return this.pluginsFutureMap.get(plugin);
        }
        return null;
    }

    <P extends DiagnosticsPlugin> P getPluginInstance(Class<P> pluginClass) {
        return (P)this.pluginsMap.get(pluginClass);
    }

    ScheduledFuture<?> getAutoOffFuture() {
        return this.autoOffFuture;
    }

    private void setConfig0(DiagnosticsConfig newConfig) {
        HashSet<String> messages = new HashSet<String>();
        this.config = new DiagnosticsConfig();
        if (this.hazelcastProperties.containsKey(OUTPUT_TYPE)) {
            this.outputType = this.hazelcastProperties.getEnum(OUTPUT_TYPE, DiagnosticsOutputType.class);
            messages.add(OUTPUT_TYPE.getName() + " = " + String.valueOf((Object)this.outputType));
        } else {
            this.outputType = newConfig.getOutputType();
        }
        if (this.hazelcastProperties.containsKey(MAX_ROLLED_FILE_SIZE_MB)) {
            this.maxRollingFileSizeMB = this.hazelcastProperties.getFloat(MAX_ROLLED_FILE_SIZE_MB);
            messages.add(MAX_ROLLED_FILE_SIZE_MB.getName() + " = " + this.hazelcastProperties.get(MAX_ROLLED_FILE_SIZE_MB.getName()));
        } else {
            this.maxRollingFileSizeMB = newConfig.getMaxRolledFileSizeInMB();
        }
        if (this.hazelcastProperties.containsKey(MAX_ROLLED_FILE_COUNT)) {
            this.maxRollingFileCount = this.hazelcastProperties.getInteger(MAX_ROLLED_FILE_COUNT);
            messages.add(MAX_ROLLED_FILE_COUNT.getName() + " = " + this.maxRollingFileCount);
        } else {
            this.maxRollingFileCount = newConfig.getMaxRolledFileCount();
        }
        if (this.hazelcastProperties.containsKey(FILENAME_PREFIX)) {
            this.filePrefix = this.hazelcastProperties.getString(FILENAME_PREFIX);
            messages.add(FILENAME_PREFIX.getName() + " = " + this.filePrefix);
        } else {
            this.filePrefix = newConfig.getFileNamePrefix();
        }
        if (this.hazelcastProperties.containsKey(INCLUDE_EPOCH_TIME)) {
            this.includeEpochTime = this.hazelcastProperties.getBoolean(INCLUDE_EPOCH_TIME);
            messages.add(INCLUDE_EPOCH_TIME.getName() + " = " + this.includeEpochTime);
        } else {
            this.includeEpochTime = newConfig.isIncludeEpochTime();
        }
        if (this.hazelcastProperties.containsKey(DIRECTORY)) {
            this.loggingDirectory = new File(this.hazelcastProperties.getString(DIRECTORY));
            messages.add(DIRECTORY.getName() + " = " + String.valueOf(this.loggingDirectory));
        } else {
            this.loggingDirectory = new File(newConfig.getLogDirectory());
        }
        if (this.hazelcastProperties.containsKey(ENABLED)) {
            boolean enabled = this.hazelcastProperties.getBoolean(ENABLED);
            if (enabled) {
                this.status.set(1);
            } else {
                this.status.set(0);
            }
            messages.add(ENABLED.getName() + " = " + enabled);
        } else {
            this.status.set(newConfig.isEnabled() ? 1 : 0);
        }
        this.config.setOutputType(this.outputType);
        this.config.setMaxRolledFileSizeInMB(this.maxRollingFileSizeMB);
        this.config.setMaxRolledFileCount(this.maxRollingFileCount);
        this.config.setLogDirectory(this.loggingDirectory.getAbsolutePath());
        this.config.setFileNamePrefix(this.filePrefix);
        this.config.setIncludeEpochTime(this.includeEpochTime);
        this.config.setEnabled(this.status.get() == 1);
        this.config.getPluginProperties().putAll(newConfig.getPluginProperties());
        this.config.setAutoOffDurationInMinutes(newConfig.getAutoOffDurationInMinutes());
        this.overridePluginProperties(messages);
        if (this.isEnabled() && !messages.isEmpty()) {
            StringBuilder sb = new StringBuilder("Diagnostics configs overridden by property: {");
            int i = 0;
            int size = messages.size();
            for (String message : messages) {
                sb.append(message);
                if (i < size - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append("}");
            this.logger.info(sb.toString());
        }
    }

    private void scheduleAutoOff() {
        if (this.status.get() == -1 || this.isConfiguredStatically()) {
            return;
        }
        if (this.isNonDynamicPluginExist() && this.config.getAutoOffDurationInMinutes() > 0) {
            String nameOfNonDynamicPlugins = this.getNameOfNonDynamicPlugins();
            this.logger.warning("Auto off cannot be scheduled since there are non-dynamic plugins running.Skipping diagnostics auto off scheduling. Detected non-dynamic plugins: " + nameOfNonDynamicPlugins);
            return;
        }
        this.cancelAutoOffFuture("Reason: Scheduling new auto off timer due to a new start.");
        if (this.config.getAutoOffDurationInMinutes() <= 0 || !this.isEnabled()) {
            return;
        }
        if (this.autoOffScheduler == null || this.autoOffScheduler.isShutdown()) {
            this.autoOffScheduler = Executors.newSingleThreadScheduledExecutor(new DiagnosticSchedulerThreadFactory("DiagnosticsAutoOffThread"));
        }
        this.setAutoOffFuture0();
    }

    private void cancelAutoOffFuture(String reason) {
        if (this.autoOffFuture != null) {
            this.autoOffFuture.cancel(true);
            this.autoOffFuture = null;
            this.logger.info("Existing auto off future cancelled. " + reason);
        }
    }

    private void setAutoOffFuture0() {
        this.logger.info(String.format("Diagnostics service is going to be disabled after %d %s.", this.config.getAutoOffDurationInMinutes(), this.autoOffDurationUnit.name()));
        this.autoOffFuture = this.autoOffScheduler.schedule(() -> {
            if (!this.isEnabled()) {
                this.logger.fine("Diagnostics service is already disabled. Skipping to schedule the auto off timer");
                return;
            }
            int tryCount = 0;
            while (!Thread.currentThread().isInterrupted() && this.isEnabled()) {
                try {
                    if (this.isNonDynamicPluginExist() && this.config.getAutoOffDurationInMinutes() > 0) {
                        String nameOfNonDynamicPlugins = this.getNameOfNonDynamicPlugins();
                        this.logger.warning("Auto off cannot disable Diagnostics because there are non-dynamic plugins running.The auto off will be ignored. Detected non-dynamic plugins: " + nameOfNonDynamicPlugins);
                        return;
                    }
                    DiagnosticsConfig dConfig = new DiagnosticsConfig(this.config);
                    dConfig.setEnabled(false);
                    this.setConfig(dConfig);
                    this.metricCollector.incrementAutoOffDisabledCount();
                }
                catch (Exception e) {
                    this.logger.warning("Auto off failed to disable diagnostics. Attempt #" + ++tryCount, e);
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        this.logger.fine("Auto off interrupted while sleeping. Exiting...");
                    }
                }
                break;
            }
        }, (long)this.config.getAutoOffDurationInMinutes(), this.autoOffDurationUnit);
    }

    private void scheduleRegisteredPlugins() {
        this.logger.finest("Scheduling the diagnostics plugins {%s}", String.join((CharSequence)", ", (CharSequence[])this.pluginsMap.keySet().stream().map(Class::getName).toArray(String[]::new)));
        HashSet<Map.Entry<Class<? extends DiagnosticsPlugin>, DiagnosticsPlugin>> pluginsSnapshot = new HashSet<Map.Entry<Class<? extends DiagnosticsPlugin>, DiagnosticsPlugin>>(this.pluginsMap.size());
        pluginsSnapshot.addAll(this.pluginsMap.entrySet());
        for (Map.Entry entry : pluginsSnapshot) {
            this.register((DiagnosticsPlugin)entry.getValue());
        }
    }

    private void cancelRunningPlugins() {
        this.logger.finest("Canceling the diagnostics plugins.");
        for (Map.Entry<Class<? extends DiagnosticsPlugin>, DiagnosticsPlugin> entry : this.pluginsMap.entrySet()) {
            if (!this.pluginsFutureMap.containsKey(entry.getValue()) || !entry.getValue().canBeEnabledDynamically()) continue;
            DiagnosticsPlugin plugin = entry.getValue();
            ScheduledFuture<?> future = this.pluginsFutureMap.remove(plugin);
            future.cancel(false);
            plugin.onShutdown();
        }
        for (DiagnosticsPlugin plugin : this.staticTasks.get()) {
            plugin.onShutdown();
        }
        this.staticTasks.set(new DiagnosticsPlugin[0]);
    }

    private void overridePluginProperties(Set<String> messages) {
        for (String prop : this.hazelcastProperties.keySet()) {
            if (!prop.startsWith(DIAGNOSTIC_PROPERTY_PREFIX)) continue;
            this.config.getPluginProperties().put(prop, this.hazelcastProperties.get(prop));
            messages.add(prop + " = " + this.hazelcastProperties.get(prop));
        }
    }

    private void emitMCConfigUpdatedEvent() {
        ManagementCenterService mcService;
        if (this.nodeEngine != null && (mcService = this.nodeEngine.getManagementCenterService()) != null) {
            mcService.log(new DiagnosticsConfigUpdatedEvent(this.config, this.nodeEngine.getLocalMember().getUuid()));
        }
    }

    private class WritePluginTask
    implements Runnable {
        private final DiagnosticsPlugin plugin;

        WritePluginTask(DiagnosticsPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void run() {
            try {
                Diagnostics.this.diagnosticsLog.write(this.plugin);
            }
            catch (Throwable t) {
                Diagnostics.this.logger.severe(t);
            }
        }
    }

    private class DiagnosticSchedulerThreadFactory
    implements ThreadFactory {
        private String name;

        DiagnosticSchedulerThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable target) {
            Runnable overriddenTarget = () -> {
                NodeEngineThreadLocalContext.declareNodeEngineReference(Diagnostics.this.nodeEngine);
                target.run();
            };
            return new Thread(overriddenTarget, ThreadUtil.createThreadName(Diagnostics.this.hzName, this.name));
        }
    }
}

