/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.logging.ILogger;

public class BuildInfoPlugin
extends DiagnosticsPlugin {
    private final BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();

    public BuildInfoPlugin(ILogger logger) {
        super(logger);
    }

    @Override
    public long getPeriodMillis() {
        return -1L;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.logger.info("Plugin:active");
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
        this.logger.info("Plugin:inactive");
    }

    @Override
    void readProperties() {
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        writer.startSection("BuildInfo");
        writer.writeKeyValueEntry("Build", this.buildInfo.getBuild());
        writer.writeKeyValueEntry("BuildNumber", String.valueOf(this.buildInfo.getBuildNumber()));
        writer.writeKeyValueEntry("Revision", this.buildInfo.getRevision());
        BuildInfo upstreamBuildInfo = this.buildInfo.getUpstreamBuildInfo();
        if (upstreamBuildInfo != null) {
            writer.writeKeyValueEntry("UpstreamRevision", upstreamBuildInfo.getRevision());
        }
        writer.writeKeyValueEntry("Version", this.buildInfo.getVersion());
        writer.writeKeyValueEntry("SerialVersion", this.buildInfo.getSerializationVersion());
        writer.writeKeyValueEntry("Enterprise", this.buildInfo.isEnterprise());
        writer.endSection();
    }
}

