/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CollectionConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.config.MergePolicyValidator;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.MutableInteger;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import com.hazelcast.spi.merge.MergingValue;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class ConfigValidator {
    public static final Set<EvictionPolicy> COMMONLY_SUPPORTED_EVICTION_POLICIES = EnumSet.of(EvictionPolicy.LRU, EvictionPolicy.LFU);
    private static final Set<MaxSizePolicy> NEAR_CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.ENTRY_COUNT);
    private static final Set<EvictionPolicy> MAP_SUPPORTED_EVICTION_POLICIES = EnumSet.of(EvictionPolicy.LRU, EvictionPolicy.LFU, EvictionPolicy.RANDOM, EvictionPolicy.NONE);
    private static final Set<MaxSizePolicy> MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.PER_NODE, new MaxSizePolicy[]{MaxSizePolicy.PER_PARTITION, MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE, MaxSizePolicy.FREE_NATIVE_MEMORY_PERCENTAGE, MaxSizePolicy.USED_NATIVE_MEMORY_SIZE, MaxSizePolicy.FREE_NATIVE_MEMORY_SIZE});
    private static final Set<MaxSizePolicy> MAP_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.PER_NODE, new MaxSizePolicy[]{MaxSizePolicy.PER_PARTITION, MaxSizePolicy.USED_HEAP_SIZE, MaxSizePolicy.USED_HEAP_PERCENTAGE, MaxSizePolicy.FREE_HEAP_SIZE, MaxSizePolicy.FREE_HEAP_PERCENTAGE});
    private static final Set<MaxSizePolicy> CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.ENTRY_COUNT);
    private static final Set<MaxSizePolicy> CACHE_SUPPORTED_NATIVE_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.USED_NATIVE_MEMORY_PERCENTAGE, MaxSizePolicy.FREE_NATIVE_MEMORY_PERCENTAGE, MaxSizePolicy.USED_NATIVE_MEMORY_SIZE, MaxSizePolicy.FREE_NATIVE_MEMORY_SIZE);

    private ConfigValidator() {
    }

    public static void checkMapConfig(Config config, MapConfig mapConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        ConfigValidator.checkNotNativeWhenOpenSource(mapConfig.getInMemoryFormat());
        ConfigValidator.checkNotBitmapIndexWhenNativeMemory(mapConfig.getInMemoryFormat(), mapConfig.getIndexConfigs());
        ConfigValidator.checkTSEnabledOnEnterpriseJar(mapConfig.getTieredStoreConfig());
        if (BuildInfoProvider.getBuildInfo().isEnterprise()) {
            ConfigValidator.checkTieredStoreMapConfig(config, mapConfig);
            ConfigValidator.checkMapNativeConfig(mapConfig, config.getNativeMemoryConfig());
        }
        ConfigValidator.checkMapEvictionConfig(mapConfig.getEvictionConfig());
        ConfigValidator.checkMapMaxSizePolicyPerInMemoryFormat(mapConfig);
        MergePolicyValidator.checkMapMergePolicy(mapConfig, mapConfig.getMergePolicyConfig().getPolicy(), mergePolicyProvider);
    }

    public static void checkTieredStoreMapConfig(Config config, MapConfig mapConfig) {
        if (!mapConfig.getTieredStoreConfig().isEnabled()) {
            return;
        }
        String mapName = mapConfig.getName();
        if (!config.getNativeMemoryConfig().isEnabled()) {
            throw new InvalidConfigurationException(String.format("Map '%s' is configured for tiered storage, but native memory is not enabled.", mapName));
        }
        DiskTierConfig diskTierConfig = mapConfig.getTieredStoreConfig().getDiskTierConfig();
        if (!diskTierConfig.isEnabled()) {
            throw new InvalidConfigurationException(String.format("Map '%s' is configured for tiered storage, but disk tier store is not enabled. Currently this is not supported, disk tier store must be enabled", mapName));
        }
        String deviceName = diskTierConfig.getDeviceName();
        if (config.getDeviceConfig(deviceName) == null) {
            throw new InvalidConfigurationException(String.format("Map '%s' is configured for tiered storage, but there is no configuration found for the device '%s' to be used for the map", mapName, deviceName));
        }
        if (mapConfig.getDataPersistenceConfig().isEnabled()) {
            throw new InvalidConfigurationException(String.format("Map '%s' is configured for tiered storage, but data persistence is also configured. Tiered store and data persistence are mutually exclusive features.", mapName));
        }
        InMemoryFormat inMemoryFormat = mapConfig.getInMemoryFormat();
        if (InMemoryFormat.NATIVE != inMemoryFormat) {
            throw new InvalidConfigurationException(String.format("Only NATIVE in-memory-format is supported for Tiered-Store but found [%s] for the map [%s]", new Object[]{inMemoryFormat, mapConfig.getName()}));
        }
        EvictionConfig evictionConfig = mapConfig.getEvictionConfig();
        if (EvictionPolicy.NONE != evictionConfig.getEvictionPolicy()) {
            throw new InvalidConfigurationException(String.format("Eviction is not supported for Tiered-Store map [%s]", mapConfig.getName()));
        }
        int timeToLiveSeconds = mapConfig.getTimeToLiveSeconds();
        if (timeToLiveSeconds != 0) {
            throw new InvalidConfigurationException(String.format("TTL expiry is not supported for Tiered-Store map [%s]", mapConfig.getName()));
        }
        int maxIdleSeconds = mapConfig.getMaxIdleSeconds();
        if (maxIdleSeconds != 0) {
            throw new InvalidConfigurationException(String.format("MaxIdle expiry is not supported for Tiered-Store map [%s]", mapConfig.getName()));
        }
    }

    static void checkMapMaxSizePolicyPerInMemoryFormat(MapConfig mapConfig) {
        MaxSizePolicy maxSizePolicy = mapConfig.getEvictionConfig().getMaxSizePolicy();
        InMemoryFormat inMemoryFormat = mapConfig.getInMemoryFormat();
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            if (!MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
                ConfigValidator.throwNotMatchingMaxSizePolicy(inMemoryFormat, maxSizePolicy, MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES);
            }
        } else if (!MAP_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            ConfigValidator.throwNotMatchingMaxSizePolicy(inMemoryFormat, maxSizePolicy, MAP_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES);
        }
    }

    private static void throwNotMatchingMaxSizePolicy(InMemoryFormat inMemoryFormat, MaxSizePolicy maxSizePolicy, Set<MaxSizePolicy> policies) {
        String msg = "%s is not a valid max size policy to use with in memory format %s. Please select an appropriate one from list: %s";
        throw new InvalidConfigurationException(String.format(msg, new Object[]{maxSizePolicy, inMemoryFormat, policies}));
    }

    public static void checkMapEvictionConfig(EvictionConfig evictionConfig) {
        EvictionPolicyComparator comparator = evictionConfig.getComparator();
        String comparatorClassName = evictionConfig.getComparatorClassName();
        EvictionPolicy evictionPolicy = evictionConfig.getEvictionPolicy();
        ConfigValidator.checkComparatorDefinedOnlyOnce(comparatorClassName, comparator);
        ConfigValidator.checkEvictionPolicyConfiguredOnlyOnce(evictionPolicy, comparatorClassName, comparator, MapConfig.DEFAULT_EVICTION_POLICY);
        ConfigValidator.checkMapMaxSizePolicyConfig(evictionConfig.getMaxSizePolicy());
    }

    public static void checkMapEvictionConfig(MaxSizePolicy maxSizePolicy, EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator) {
        ConfigValidator.checkEvictionConfig(evictionPolicy, comparatorClassName, comparator, MAP_SUPPORTED_EVICTION_POLICIES);
        ConfigValidator.checkMapMaxSizePolicyConfig(maxSizePolicy);
    }

    static void checkMapMaxSizePolicyConfig(MaxSizePolicy maxSizePolicy) {
        if (!MAP_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy) && !MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            EnumSet<MaxSizePolicy> allMaxSizePolicies = EnumSet.copyOf(MAP_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES);
            allMaxSizePolicies.addAll(MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES);
            String msg = String.format("IMap eviction config doesn't support max size policy `%s`. Please select a valid one: %s.", new Object[]{maxSizePolicy, allMaxSizePolicies});
            throw new InvalidConfigurationException(msg);
        }
    }

    private static void checkMapNativeConfig(MapConfig mapConfig, NativeMemoryConfig nativeMemoryConfig) {
        if (InMemoryFormat.NATIVE != mapConfig.getInMemoryFormat()) {
            return;
        }
        Preconditions.checkTrue(nativeMemoryConfig.isEnabled(), String.format("Enable native memory config to use NATIVE in-memory-format for the map [%s]", mapConfig.getName()));
        ConfigValidator.checkMapNativeMaxSizePolicy(mapConfig);
    }

    private static void checkMapNativeMaxSizePolicy(MapConfig mapConfig) {
        MaxSizePolicy maxSizePolicy = mapConfig.getEvictionConfig().getMaxSizePolicy();
        if (!MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            throw new InvalidConfigurationException("Maximum size policy " + String.valueOf((Object)maxSizePolicy) + " cannot be used with NATIVE in memory format backed Map. Supported maximum size policies are: " + String.valueOf(MAP_SUPPORTED_NATIVE_MAX_SIZE_POLICIES));
        }
    }

    public static void warnForUsageOfDeprecatedSymmetricEncryption(Config config, ILogger logger) {
        String warn = "Symmetric encryption is deprecated and will be removed in a future version. Consider using TLS instead.";
        boolean usesAdvancedNetworkConfig = config.getAdvancedNetworkConfig().isEnabled();
        if (config.getNetworkConfig() != null && config.getNetworkConfig().getSymmetricEncryptionConfig() != null && config.getNetworkConfig().getSymmetricEncryptionConfig().isEnabled() && !usesAdvancedNetworkConfig) {
            logger.warning(warn);
        }
        if (config.getAdvancedNetworkConfig() != null && config.getAdvancedNetworkConfig().getEndpointConfigs() != null && usesAdvancedNetworkConfig) {
            for (EndpointConfig endpointConfig : config.getAdvancedNetworkConfig().getEndpointConfigs().values()) {
                if (endpointConfig.getSymmetricEncryptionConfig() == null || !endpointConfig.getSymmetricEncryptionConfig().isEnabled()) continue;
                logger.warning(warn);
                break;
            }
        }
    }

    public static void checkAdvancedNetworkConfig(Config config) {
        if (!config.getAdvancedNetworkConfig().isEnabled()) {
            return;
        }
        EnumMap<ProtocolType, MutableInteger> serverSocketsPerProtocolType = new EnumMap<ProtocolType, MutableInteger>(ProtocolType.class);
        for (ProtocolType protocolType : ProtocolType.values()) {
            serverSocketsPerProtocolType.put(protocolType, new MutableInteger());
        }
        Map<EndpointQualifier, EndpointConfig> endpointConfigs = config.getAdvancedNetworkConfig().getEndpointConfigs();
        for (EndpointConfig endpointConfig : endpointConfigs.values()) {
            if (!(endpointConfig instanceof ServerSocketEndpointConfig)) continue;
            ((MutableInteger)serverSocketsPerProtocolType.get((Object)endpointConfig.getProtocolType())).getAndInc();
        }
        ProtocolType[] protocolTypeArray = ProtocolType.values();
        int endpointConfig = protocolTypeArray.length;
        for (int i = 0; i < endpointConfig; ++i) {
            ProtocolType protocolType;
            int serverSocketCount = ((MutableInteger)serverSocketsPerProtocolType.get((Object)((Object)protocolType))).value;
            protocolType = protocolTypeArray[i];
            if (serverSocketCount <= protocolType.getServerSocketCardinality()) continue;
            throw new InvalidConfigurationException(String.format("Protocol type %s allows definition of up to %d server sockets but %d were configured", new Object[]{protocolType, protocolType.getServerSocketCardinality(), serverSocketCount}));
        }
        if (((MutableInteger)serverSocketsPerProtocolType.get((Object)((Object)ProtocolType.MEMBER))).value != 1) {
            throw new InvalidConfigurationException("A member-server-socket-endpoint configuration is required for the cluster to form.");
        }
        for (WanReplicationConfig wanReplicationConfig : config.getWanReplicationConfigs().values()) {
            for (WanBatchPublisherConfig wanPublisherConfig : wanReplicationConfig.getBatchPublisherConfigs()) {
                EndpointQualifier qualifier;
                if (wanPublisherConfig.getEndpoint() == null || endpointConfigs.get(qualifier = EndpointQualifier.resolve(ProtocolType.WAN, wanPublisherConfig.getEndpoint())) != null) continue;
                throw new InvalidConfigurationException(String.format("WAN publisher config for cluster name '%s' requires an wan-endpoint config with identifier '%s' but none was found", wanPublisherConfig.getClusterName(), wanPublisherConfig.getEndpoint()));
            }
        }
    }

    public static void checkNearCacheConfig(String mapName, NearCacheConfig nearCacheConfig, NativeMemoryConfig nativeMemoryConfig, boolean isClient) {
        ConfigValidator.checkNotNativeWhenOpenSource(nearCacheConfig.getInMemoryFormat());
        ConfigValidator.checkLocalUpdatePolicy(mapName, nearCacheConfig.getLocalUpdatePolicy());
        EvictionConfig evictionConfig = nearCacheConfig.getEvictionConfig();
        ConfigValidator.checkNearCacheEvictionConfig(evictionConfig.getEvictionPolicy(), evictionConfig.getComparatorClassName(), evictionConfig.getComparator());
        ConfigValidator.checkOnHeapNearCacheMaxSizePolicy(nearCacheConfig);
        ConfigValidator.checkNearCacheNativeMemoryConfig(nearCacheConfig.getInMemoryFormat(), nativeMemoryConfig, BuildInfoProvider.getBuildInfo().isEnterprise());
        if (isClient && nearCacheConfig.isCacheLocalEntries()) {
            throw new InvalidConfigurationException("The Near Cache option `cache-local-entries` is not supported in client configurations.");
        }
        ConfigValidator.checkPreloaderConfig(nearCacheConfig, isClient);
    }

    private static void checkLocalUpdatePolicy(String mapName, NearCacheConfig.LocalUpdatePolicy localUpdatePolicy) {
        if (localUpdatePolicy != NearCacheConfig.LocalUpdatePolicy.INVALIDATE) {
            throw new InvalidConfigurationException(String.format("Wrong `local-update-policy` option is selected for `%s` map Near Cache. Only `%s` option is supported but found `%s`", new Object[]{mapName, NearCacheConfig.LocalUpdatePolicy.INVALIDATE, localUpdatePolicy}));
        }
    }

    public static void checkCacheEvictionConfig(EvictionConfig evictionConfig) {
        ConfigValidator.checkEvictionConfig(evictionConfig, COMMONLY_SUPPORTED_EVICTION_POLICIES);
    }

    public static void checkEvictionConfig(EvictionConfig evictionConfig, Set<EvictionPolicy> supportedEvictionPolicies) {
        if (evictionConfig == null) {
            throw new InvalidConfigurationException("Eviction config cannot be null!");
        }
        EvictionPolicy evictionPolicy = evictionConfig.getEvictionPolicy();
        String comparatorClassName = evictionConfig.getComparatorClassName();
        EvictionPolicyComparator comparator = evictionConfig.getComparator();
        ConfigValidator.checkEvictionConfig(evictionPolicy, comparatorClassName, comparator, supportedEvictionPolicies);
    }

    private static void checkOnHeapNearCacheMaxSizePolicy(NearCacheConfig nearCacheConfig) {
        InMemoryFormat inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            return;
        }
        MaxSizePolicy maxSizePolicy = nearCacheConfig.getEvictionConfig().getMaxSizePolicy();
        if (!NEAR_CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            throw new InvalidConfigurationException(String.format("Near Cache maximum size policy %s cannot be used with %s storage. Supported maximum size policies are: %s", new Object[]{maxSizePolicy, inMemoryFormat, NEAR_CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES}));
        }
    }

    static void checkNearCacheNativeMemoryConfig(InMemoryFormat inMemoryFormat, NativeMemoryConfig nativeMemoryConfig, boolean isEnterprise) {
        if (!isEnterprise) {
            return;
        }
        if (inMemoryFormat != InMemoryFormat.NATIVE) {
            return;
        }
        if (nativeMemoryConfig != null && nativeMemoryConfig.isEnabled()) {
            return;
        }
        throw new InvalidConfigurationException("Enable native memory config to use NATIVE in-memory-format for Near Cache");
    }

    public static void checkEvictionConfig(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator, Set<EvictionPolicy> supportedEvictionPolicies) {
        ConfigValidator.checkComparatorDefinedOnlyOnce(comparatorClassName, comparator);
        if (!supportedEvictionPolicies.contains((Object)evictionPolicy)) {
            if (StringUtil.isNullOrEmpty(comparatorClassName) && comparator == null) {
                String msg = String.format("Eviction policy `%s` is not supported. Either you can provide a custom one or you can use a supported one: %s.", new Object[]{evictionPolicy, supportedEvictionPolicies});
                throw new InvalidConfigurationException(msg);
            }
        } else {
            ConfigValidator.checkEvictionPolicyConfiguredOnlyOnce(evictionPolicy, comparatorClassName, comparator, EvictionConfig.DEFAULT_EVICTION_POLICY);
        }
    }

    private static void checkComparatorDefinedOnlyOnce(String comparatorClassName, Object comparator) {
        if (comparatorClassName != null && comparator != null) {
            throw new InvalidConfigurationException("Only one of the `comparator class name` and `comparator` can be configured in the eviction configuration!");
        }
    }

    public static void checkNearCacheEvictionConfig(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator) {
        ConfigValidator.checkComparatorDefinedOnlyOnce(comparatorClassName, comparator);
        ConfigValidator.checkEvictionPolicyConfiguredOnlyOnce(evictionPolicy, comparatorClassName, comparator, EvictionConfig.DEFAULT_EVICTION_POLICY);
    }

    private static void checkEvictionPolicyConfiguredOnlyOnce(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator, EvictionPolicy defaultEvictionPolicy) {
        if (evictionPolicy != defaultEvictionPolicy) {
            if (!StringUtil.isNullOrEmpty(comparatorClassName)) {
                throw new InvalidConfigurationException("Only one of the `eviction policy` and `comparator class name` can be configured!");
            }
            if (comparator != null) {
                throw new InvalidConfigurationException("Only one of the `eviction policy` and `comparator` can be configured!");
            }
        }
    }

    public static void checkCacheConfig(CacheSimpleConfig cacheSimpleConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        ConfigValidator.checkCacheConfig(cacheSimpleConfig.getInMemoryFormat(), cacheSimpleConfig.getEvictionConfig(), cacheSimpleConfig.getMergePolicyConfig().getPolicy(), SplitBrainMergeTypes.CacheMergeTypes.class, mergePolicyProvider, COMMONLY_SUPPORTED_EVICTION_POLICIES, cacheSimpleConfig.getUserCodeNamespace());
    }

    public static void checkCacheConfig(CacheConfig cacheConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        ConfigValidator.checkCacheConfig(cacheConfig.getInMemoryFormat(), cacheConfig.getEvictionConfig(), cacheConfig.getMergePolicyConfig().getPolicy(), SplitBrainMergeTypes.CacheMergeTypes.class, mergePolicyProvider, COMMONLY_SUPPORTED_EVICTION_POLICIES, cacheConfig.getUserCodeNamespace());
    }

    private static void checkCacheConfig(InMemoryFormat inMemoryFormat, EvictionConfig evictionConfig, String mergePolicyClassname, Class<? extends MergingValue> mergeTypes, SplitBrainMergePolicyProvider mergePolicyProvider, Set<EvictionPolicy> supportedEvictionPolicies, @Nullable String namespace) {
        try {
            ConfigValidator.checkNotNativeWhenOpenSource(inMemoryFormat);
            ConfigValidator.checkEvictionConfig(evictionConfig, supportedEvictionPolicies);
            ConfigValidator.checkCacheMaxSizePolicy(evictionConfig.getMaxSizePolicy(), inMemoryFormat);
            MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(mergeTypes, mergePolicyProvider, mergePolicyClassname, namespace);
        }
        catch (InvalidConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage(), e.getCause());
        }
    }

    static void checkCacheMaxSizePolicy(MaxSizePolicy maxSizePolicy, InMemoryFormat inMemoryFormat) {
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            if (!CACHE_SUPPORTED_NATIVE_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
                throw new IllegalArgumentException("Maximum size policy " + String.valueOf((Object)maxSizePolicy) + " cannot be used with NATIVE in memory format backed Cache. Supported maximum size policies are: " + String.valueOf(CACHE_SUPPORTED_NATIVE_MAX_SIZE_POLICIES));
            }
        } else if (!CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            String msg = String.format("Cache eviction config doesn't support max size policy `%s`. Please select a valid one: %s.", new Object[]{maxSizePolicy, CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES});
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkReplicatedMapConfig(ReplicatedMapConfig replicatedMapConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(SplitBrainMergeTypes.ReplicatedMapMergeTypes.class, mergePolicyProvider, replicatedMapConfig.getMergePolicyConfig().getPolicy(), replicatedMapConfig.getUserCodeNamespace());
    }

    public static void checkMultiMapConfig(MultiMapConfig multiMapConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(SplitBrainMergeTypes.MultiMapMergeTypes.class, mergePolicyProvider, multiMapConfig.getMergePolicyConfig().getPolicy(), multiMapConfig.getUserCodeNamespace());
    }

    public static void checkQueueConfig(QueueConfig queueConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(SplitBrainMergeTypes.QueueMergeTypes.class, mergePolicyProvider, queueConfig.getMergePolicyConfig().getPolicy(), queueConfig.getUserCodeNamespace());
    }

    public static void checkCollectionConfig(CollectionConfig collectionConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(SplitBrainMergeTypes.CollectionMergeTypes.class, mergePolicyProvider, collectionConfig.getMergePolicyConfig().getPolicy(), collectionConfig.getUserCodeNamespace());
    }

    public static void checkRingbufferConfig(RingbufferConfig ringbufferConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(SplitBrainMergeTypes.RingbufferMergeTypes.class, mergePolicyProvider, ringbufferConfig.getMergePolicyConfig().getPolicy(), ringbufferConfig.getUserCodeNamespace());
    }

    public static void checkScheduledExecutorConfig(ScheduledExecutorConfig scheduledExecutorConfig, SplitBrainMergePolicyProvider mergePolicyProvider) {
        String mergePolicyClassName = scheduledExecutorConfig.getMergePolicyConfig().getPolicy();
        MergePolicyValidator.checkMergeTypeProviderHasRequiredTypes(SplitBrainMergeTypes.ScheduledExecutorMergeTypes.class, mergePolicyProvider, mergePolicyClassName, scheduledExecutorConfig.getUserCodeNamespace());
    }

    public static void checkCPSubsystemConfig(CPSubsystemConfig config) {
        Preconditions.checkTrue(config.getGroupSize() <= config.getCPMemberCount(), "The group size parameter cannot be bigger than the number of the CP member count");
        Preconditions.checkTrue(config.getSessionTimeToLiveSeconds() > config.getSessionHeartbeatIntervalSeconds(), "Session TTL must be greater than session heartbeat interval!");
        Preconditions.checkTrue(config.getMissingCPMemberAutoRemovalSeconds() == 0 || config.getSessionTimeToLiveSeconds() <= config.getMissingCPMemberAutoRemovalSeconds(), "Session TTL must be smaller than or equal to missing CP member auto-removal seconds!");
        Preconditions.checkTrue(!config.isPersistenceEnabled() || config.getCPMemberCount() > 0, "CP member count must be greater than 0 to use CP persistence feature!");
    }

    private static void checkNotNativeWhenOpenSource(InMemoryFormat inMemoryFormat) {
        if (inMemoryFormat == InMemoryFormat.NATIVE && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new InvalidConfigurationException("NATIVE storage format is supported in Hazelcast Enterprise only. Make sure you have Hazelcast Enterprise JARs on your classpath!");
        }
    }

    private static void checkTSEnabledOnEnterpriseJar(TieredStoreConfig tieredStoreConfig) {
        if (tieredStoreConfig.isEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new InvalidConfigurationException("Tiered-Store is supported in Hazelcast Enterprise only. Please make sure you have Hazelcast Enterprise JARs on your classpath.");
        }
    }

    private static void checkNotBitmapIndexWhenNativeMemory(InMemoryFormat inMemoryFormat, List<IndexConfig> indexConfigs) {
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            for (IndexConfig indexConfig : indexConfigs) {
                if (indexConfig.getType() != IndexType.BITMAP) continue;
                throw new InvalidConfigurationException("BITMAP indexes are not supported by NATIVE storage");
            }
        }
    }

    private static void checkPreloaderConfig(NearCacheConfig nearCacheConfig, boolean isClient) {
        if (!isClient && nearCacheConfig.getPreloaderConfig().isEnabled()) {
            throw new InvalidConfigurationException("The Near Cache pre-loader is just available on Hazelcast clients!");
        }
    }

    public static void checkSecurityConfig(Node node, SecurityConfig securityConfig) {
        if (!securityConfig.isEnabled()) {
            return;
        }
        Map<String, RealmConfig> realmConfigs = securityConfig.getRealmConfigs();
        ArrayList errors = new ArrayList();
        if (realmConfigs != null) {
            realmConfigs.values().forEach(realmConfig -> {
                JaasAuthenticationConfig jaas = realmConfig.getJaasAuthenticationConfig();
                if (jaas != null) {
                    for (LoginModuleConfig jaasLoginModuleConfig : jaas.getLoginModuleConfigs()) {
                        ClassLoader configClassLoader = node.getConfigClassLoader();
                        String className = jaasLoginModuleConfig.getClassName();
                        if (!ConfigValidator.isNotBlank(className) || ClassLoaderUtil.isClassAvailable(configClassLoader, className)) continue;
                        errors.add(className);
                    }
                }
            });
        }
        if (!errors.isEmpty()) {
            throw new InvalidConfigurationException("Login module class(es) not found: " + String.join((CharSequence)", ", errors));
        }
    }

    private static boolean isNotBlank(String className) {
        return className != null && !className.isEmpty();
    }
}

