/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public final class ConfigUtils {
    private static final ILogger LOGGER = Logger.getLogger(Config.class);
    private static final BiConsumer<NamedConfig, String> DEFAULT_NAME_SETTER = NamedConfig::setName;

    private ConfigUtils() {
    }

    public static <T> T lookupByPattern(ConfigPatternMatcher configPatternMatcher, Map<String, T> configPatterns, String itemName) {
        T candidate = configPatterns.get(itemName);
        if (candidate != null) {
            return candidate;
        }
        String configPatternKey = configPatternMatcher.matches(configPatterns.keySet(), itemName);
        if (configPatternKey != null) {
            return configPatterns.get(configPatternKey);
        }
        if (!"default".equals(itemName) && !itemName.startsWith("hz:")) {
            LOGGER.finest("No configuration found for %s, using default config!", itemName);
        }
        return null;
    }

    public static <T extends NamedConfig> T getConfig(ConfigPatternMatcher configPatternMatcher, Map<String, T> configs, String name, Class clazz) {
        return (T)ConfigUtils.getConfig(configPatternMatcher, configs, name, clazz, DEFAULT_NAME_SETTER);
    }

    public static <T> T getConfig(ConfigPatternMatcher configPatternMatcher, Map<String, T> configs, String name, Class clazz, BiConsumer<T, String> nameSetter) {
        T config = ConfigUtils.lookupByPattern(configPatternMatcher, configs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return config;
        }
        T defConfig = configs.get("default");
        try {
            if (defConfig == null) {
                defConfig = ConfigUtils.constructReflectively(clazz);
                nameSetter.accept(defConfig, "default");
                configs.put("default", defConfig);
            }
            config = ConfigUtils.cloneClass(clazz, defConfig);
            nameSetter.accept(config, name);
            configs.put(name, config);
            return config;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.severe("Could not create class " + clazz.getName());
            assert (false);
            return null;
        }
    }

    private static <T> T cloneClass(Class<?> clazz, T defConfig) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> copyConstructor = clazz.getDeclaredConstructor(clazz);
        copyConstructor.setAccessible(true);
        return (T)copyConstructor.newInstance(defConfig);
    }

    public static <T extends NamedConfig, S extends T> T getByNameOrNew(Map<String, T> configs, String name, Class<S> clazz) {
        NamedConfig config = (NamedConfig)configs.get(name);
        if (config != null) {
            return (T)config;
        }
        try {
            config = (NamedConfig)ConfigUtils.constructReflectively(clazz);
            config.setName(name);
            configs.put(name, config);
            return (T)config;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.severe("Could not create class " + clazz.getName());
            assert (false);
            return null;
        }
    }

    @Nonnull
    private static <T> T constructReflectively(Class<T> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        T config = constructor.newInstance(new Object[0]);
        return config;
    }

    public static InvalidConfigurationException createAmbiguousConfigurationException(String itemName, String candidate, String duplicate) {
        return new InvalidConfigurationException(String.format("Found ambiguous configurations for item\"%s\": \"%s\" vs. \"%s\"%nPlease specify your configuration.", itemName, candidate, duplicate));
    }

    public static boolean matches(String configName, String configName2) {
        return configName != null && configName2 != null && configName.replace("-", "").equals(configName2.replace("-", ""));
    }

    @Nonnull
    public static String resolveResourceId(String providedId, URL url) {
        if (!StringUtil.isNullOrEmpty(providedId)) {
            return providedId;
        }
        return ConfigUtils.urlToFileName(url);
    }

    private static String urlToFileName(URL url) {
        String filename = new File(url.getPath()).getName();
        return Preconditions.checkHasText(filename, "URL has no path: " + String.valueOf(url));
    }
}

