/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.internal.config.ConfigSections;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ConfigNamespace {
    private final ConfigSections configSection;
    private final String configName;

    public ConfigNamespace(@Nonnull ConfigSections configSection, @Nonnull String configName) {
        this.configSection = configSection;
        this.configName = configName;
    }

    public ConfigNamespace(@Nonnull ConfigSections configSection) {
        this.configSection = configSection;
        this.configName = null;
    }

    public ConfigSections getConfigSection() {
        return this.configSection;
    }

    public String getSectionName() {
        return this.configSection.getName();
    }

    public String getConfigName() {
        return this.configName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigNamespace that = (ConfigNamespace)o;
        return this.configSection == that.configSection && Objects.equals(this.configName, that.configName);
    }

    public String toString() {
        return "ConfigNamespace{configSection=" + String.valueOf((Object)this.configSection) + ", configName='" + this.configName + "'}";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configSection, this.configName});
    }
}

