/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.cluster.impl.ConfigCheck;
import com.hazelcast.internal.cluster.impl.JoinMessage;
import com.hazelcast.internal.cluster.impl.operations.OnJoinOp;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.security.Credentials;
import com.hazelcast.version.MemberVersion;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class JoinRequest
extends JoinMessage {
    private static final Version SUPPORTS_PREJOIN_VERSION = Versions.V5_3;
    private static final MemberVersion SUPPORTS_SUPPORTED_VERSIONS_FIELD = MemberVersion.of(5, 5, 3);
    private Credentials credentials;
    private int tryCount;
    private Map<String, String> attributes;
    private Set<UUID> excludedMemberUuids = Collections.emptySet();
    private Map<EndpointQualifier, Address> addresses;
    private UUID cpMemberUUID;
    private OnJoinOp preJoinOperation;
    private Set<Version> supportedClusterVersions = Collections.emptySet();

    public JoinRequest() {
    }

    public JoinRequest(int buildNumber, MemberVersion version, Address address, Member member, ConfigCheck config, Credentials credentials, Set<UUID> excludedMemberUuids, UUID cpMemberUUID, OnJoinOp preJoinOperation, Set<Version> versions) {
        super(buildNumber, version, address, member.getUuid(), member.isLiteMember(), config);
        this.credentials = credentials;
        this.attributes = member.getAttributes();
        if (excludedMemberUuids != null) {
            this.excludedMemberUuids = Set.copyOf(excludedMemberUuids);
        }
        this.addresses = member.getAddressMap();
        this.cpMemberUUID = cpMemberUUID;
        this.preJoinOperation = preJoinOperation;
        this.supportedClusterVersions = Objects.requireNonNull(versions, "supportedClusterVersions must not be null");
    }

    public JoinRequest(int buildNumber, MemberVersion version, Address address, Member member, Set<Version> versions) {
        super(buildNumber, version, address, member.getUuid(), member.isLiteMember(), null);
        this.attributes = member.getAttributes();
        if (this.excludedMemberUuids != null) {
            this.excludedMemberUuids = Set.copyOf(this.excludedMemberUuids);
        }
        this.addresses = member.getAddressMap();
        this.supportedClusterVersions = Objects.requireNonNull(versions, "supportedClusterVersions must be non-null");
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Set<UUID> getExcludedMemberUuids() {
        return this.excludedMemberUuids;
    }

    public OnJoinOp getPreJoinOperation() {
        return this.preJoinOperation;
    }

    public MemberInfo toMemberInfo() {
        return new MemberInfo(this.address, this.uuid, this.cpMemberUUID, this.attributes, this.liteMember, this.memberVersion, this.addresses);
    }

    public boolean supportsVersion(Version version) {
        return this.supportedClusterVersions.contains(version);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.credentials = (Credentials)in.readObject();
        this.tryCount = in.readInt();
        int size = in.readInt();
        this.attributes = MapUtil.createHashMap(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.attributes.put(key, value);
        }
        size = in.readInt();
        Set<UUID> excludedMemberUuids = SetUtil.createHashSet(size);
        for (int i = 0; i < size; ++i) {
            excludedMemberUuids.add(UUIDSerializationUtil.readUUID(in));
        }
        this.excludedMemberUuids = Collections.unmodifiableSet(excludedMemberUuids);
        this.addresses = SerializationUtil.readMap(in);
        this.cpMemberUUID = UUIDSerializationUtil.readUUID(in);
        if (this.memberVersion.asVersion().isGreaterOrEqual(SUPPORTS_PREJOIN_VERSION)) {
            this.preJoinOperation = (OnJoinOp)in.readObject();
        }
        if (this.memberVersion.isGreaterOrEqual(SUPPORTS_SUPPORTED_VERSIONS_FIELD)) {
            int clusterVersions = in.readInt();
            this.supportedClusterVersions = SetUtil.createHashSet(clusterVersions);
            for (int i = 0; i < clusterVersions; ++i) {
                this.supportedClusterVersions.add((Version)in.readObject());
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.credentials);
        out.writeInt(this.tryCount);
        out.writeInt(this.attributes.size());
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeInt(this.excludedMemberUuids.size());
        for (UUID uuid : this.excludedMemberUuids) {
            UUIDSerializationUtil.writeUUID(out, uuid);
        }
        SerializationUtil.writeMap(this.addresses, out);
        UUIDSerializationUtil.writeUUID(out, this.cpMemberUUID);
        out.writeObject(this.preJoinOperation);
        out.writeInt(this.supportedClusterVersions.size());
        for (Version version : this.supportedClusterVersions) {
            out.writeObject(version);
        }
    }

    @Override
    public String toString() {
        return "JoinRequest{packetVersion=" + this.packetVersion + ", buildNumber=" + this.buildNumber + ", memberVersion=" + String.valueOf(this.memberVersion) + ", address=" + String.valueOf(this.address) + ", uuid='" + String.valueOf(this.uuid) + "', cpMemberUUID='" + String.valueOf(this.cpMemberUUID) + "', liteMember=" + this.liteMember + ", credentials=" + String.valueOf(this.credentials) + ", memberCount=" + this.getMemberCount() + ", tryCount=" + this.tryCount + (String)(this.excludedMemberUuids.isEmpty() ? "" : ", excludedMemberUuids=" + String.valueOf(this.excludedMemberUuids)) + (String)(this.supportedClusterVersions.isEmpty() ? "" : ", supportedClusterVersions=" + String.valueOf(this.supportedClusterVersions)) + "}";
    }

    @Override
    public int getClassId() {
        return 27;
    }
}

