/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.BootstrappedInstanceProxy;
import com.hazelcast.instance.impl.BootstrappedInstanceProxyFactory;
import com.hazelcast.instance.impl.executejar.CommandLineExecuteJar;
import com.hazelcast.instance.impl.executejar.ExecuteJobParameters;
import com.hazelcast.instance.impl.executejar.MemberExecuteJar;
import com.hazelcast.instance.impl.executejar.ResettableSingleton;
import com.hazelcast.jet.impl.util.JetConsoleLogHandler;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.properties.ClusterProperty;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HazelcastBootstrap {
    private static final ResettableSingleton<BootstrappedInstanceProxy> SINGLETON = new ResettableSingleton();
    private static final ILogger LOGGER = Logger.getLogger(HazelcastBootstrap.class);
    private static final AtomicBoolean LOGGING_CONFIGURED = new AtomicBoolean();

    private HazelcastBootstrap() {
    }

    public static void resetRemembered() {
        SINGLETON.resetRemembered();
    }

    public static void executeJarOnCLI(@Nonnull Supplier<HazelcastInstance> supplierOfInstance, @Nonnull String jarPath, @Nullable String snapshotName, @Nullable String jobName, @Nullable String mainClassName, @Nonnull List<String> args) throws IOException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        SINGLETON.get(() -> BootstrappedInstanceProxyFactory.createWithCLIJetProxy((HazelcastInstance)supplierOfInstance.get()));
        ExecuteJobParameters executeJobParameters = new ExecuteJobParameters(jarPath, snapshotName, jobName);
        CommandLineExecuteJar commandLineExecuteJar = new CommandLineExecuteJar();
        commandLineExecuteJar.executeJar(SINGLETON, executeJobParameters, mainClassName, args);
    }

    public static void executeJarOnMember(@Nonnull Supplier<HazelcastInstance> supplierOfInstance, @Nonnull String jarPath, @Nullable String snapshotName, @Nullable String jobName, @Nullable String mainClassName, @Nonnull List<String> args) throws IOException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        BootstrappedInstanceProxy hazelcastInstance = SINGLETON.get(() -> BootstrappedInstanceProxyFactory.createWithMemberJetProxy((HazelcastInstance)supplierOfInstance.get()).setShutDownAllowed(false));
        ExecuteJobParameters executeJobParameters = new ExecuteJobParameters(jarPath, snapshotName, jobName);
        MemberExecuteJar memberExecuteJar = new MemberExecuteJar();
        memberExecuteJar.executeJar(hazelcastInstance, executeJobParameters, mainClassName, args);
    }

    @Nonnull
    public static synchronized HazelcastInstance getInstance() {
        return SINGLETON.get(() -> BootstrappedInstanceProxyFactory.createWithCLIJetProxy(HazelcastBootstrap.createStandaloneInstance()));
    }

    private static HazelcastInstance createStandaloneInstance() {
        HazelcastBootstrap.configureLogging();
        LOGGER.info("Bootstrapped instance requested but application wasn't called from hazelcast submit script. Creating a standalone Hazelcast instance instead. Jet is enabled in this standalone instance.");
        Config config = Config.load();
        config.getJetConfig().setEnabled(true);
        config.setProperty(ClusterProperty.SOCKET_BIND_ANY.getName(), "false");
        config.getNetworkConfig().getInterfaces().setEnabled(true).addInterface("127.0.0.1");
        config.setProperty("hazelcast.wait.seconds.before.join", "0");
        config.getAdvancedNetworkConfig().setEnabled(false);
        JoinConfig join = config.getNetworkConfig().getJoin();
        join.getAutoDetectionConfig().setEnabled(false);
        join.getMulticastConfig().setEnabled(false);
        join.getTcpIpConfig().setEnabled(false);
        join.getAwsConfig().setEnabled(false);
        join.getGcpConfig().setEnabled(false);
        join.getAzureConfig().setEnabled(false);
        join.getKubernetesConfig().setEnabled(false);
        join.getEurekaConfig().setEnabled(false);
        join.setDiscoveryConfig(new DiscoveryConfig());
        return Hazelcast.newHazelcastInstance(config);
    }

    public static void configureLogging() {
        if (LOGGING_CONFIGURED.compareAndSet(false, true)) {
            try {
                String loggingType = System.getProperty(ClusterProperty.LOGGING_TYPE.getName(), "jdk");
                if (loggingType.equals("jdk")) {
                    java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
                    for (Handler handler : rootLogger.getHandlers()) {
                        if (!(handler instanceof ConsoleHandler)) continue;
                        rootLogger.removeHandler(handler);
                        rootLogger.addHandler(new JetConsoleLogHandler());
                        rootLogger.setLevel(Level.INFO);
                        return;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.severe("Error configuring java.util.logging for Hazelcast: " + String.valueOf(e));
            }
        }
    }
}

