/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class CPGroupsSnapshot {
    public static final CPGroupsSnapshot EMPTY = new CPGroupsSnapshot(Collections.emptyMap(), Collections.emptyMap());
    private final Map<CPGroupId, GroupInfo> groupIdToInfo;
    private final Map<UUID, UUID> cpToApUuids;

    public CPGroupsSnapshot(Map<CPGroupId, GroupInfo> groupIdToInfo, Map<UUID, UUID> cpToApUuids) {
        this.groupIdToInfo = groupIdToInfo;
        this.cpToApUuids = cpToApUuids;
    }

    public CPGroupsSnapshot(Map<CPGroupId, GroupInfo> groupIdToInfo) {
        this.groupIdToInfo = groupIdToInfo;
        this.cpToApUuids = Collections.emptyMap();
    }

    public Map<CPGroupId, GroupInfo> getAllGroupInformation() {
        return this.groupIdToInfo;
    }

    public CPMember getLeader(CPGroupId groupId) {
        GroupInfo info = this.groupIdToInfo.get(groupId);
        return info == null ? null : info.leader();
    }

    public Map<UUID, UUID> getCpToApUuids() {
        return this.cpToApUuids;
    }

    public UUID getApUuid(CPMember cpMember) {
        return this.cpToApUuids.get(cpMember.getUuid());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CPGroupsSnapshot that = (CPGroupsSnapshot)o;
        return Objects.equals(this.groupIdToInfo, that.groupIdToInfo) && Objects.equals(this.cpToApUuids, that.cpToApUuids);
    }

    public int hashCode() {
        return Objects.hash(this.groupIdToInfo, this.cpToApUuids);
    }

    public String toString() {
        return "CPGroupsSnapshot{groupIdToInfo=" + String.valueOf(this.groupIdToInfo) + ", cpToApUuids=" + String.valueOf(this.cpToApUuids) + "}";
    }

    public record GroupInfo(CPMember leader, Set<CPMember> followers, int term) {
    }
}

