/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.UserCodeNamespaceAwareConfig;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ReplicatedMapConfig
implements IdentifiedDataSerializable,
NamedConfig,
Versioned,
UserCodeNamespaceAwareConfig<ReplicatedMapConfig> {
    public static final InMemoryFormat DEFAULT_IN_MEMORY_FORMAT = InMemoryFormat.OBJECT;
    public static final boolean DEFAULT_ASNYC_FILLUP = true;
    private boolean statisticsEnabled = true;
    private boolean asyncFillup = true;
    private String name;
    private String splitBrainProtectionName;
    private List<ListenerConfig> listenerConfigs = new ArrayList<ListenerConfig>();
    private InMemoryFormat inMemoryFormat = DEFAULT_IN_MEMORY_FORMAT;
    private MergePolicyConfig mergePolicyConfig = new MergePolicyConfig();
    @Nullable
    private String userCodeNamespace = DEFAULT_NAMESPACE;

    public ReplicatedMapConfig() {
    }

    public ReplicatedMapConfig(String name) {
        this.setName(name);
    }

    public ReplicatedMapConfig(ReplicatedMapConfig replicatedMapConfig) {
        this.name = replicatedMapConfig.name;
        this.inMemoryFormat = replicatedMapConfig.inMemoryFormat;
        this.listenerConfigs = replicatedMapConfig.listenerConfigs == null ? null : new ArrayList<ListenerConfig>(replicatedMapConfig.getListenerConfigs());
        this.asyncFillup = replicatedMapConfig.asyncFillup;
        this.statisticsEnabled = replicatedMapConfig.statisticsEnabled;
        this.mergePolicyConfig = new MergePolicyConfig(replicatedMapConfig.mergePolicyConfig);
        this.splitBrainProtectionName = replicatedMapConfig.splitBrainProtectionName;
        this.userCodeNamespace = replicatedMapConfig.userCodeNamespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ReplicatedMapConfig setName(String name) {
        this.name = name;
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public ReplicatedMapConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        this.inMemoryFormat = inMemoryFormat;
        return this;
    }

    public List<ListenerConfig> getListenerConfigs() {
        if (this.listenerConfigs == null) {
            this.listenerConfigs = new ArrayList<ListenerConfig>();
        }
        return this.listenerConfigs;
    }

    public ReplicatedMapConfig setListenerConfigs(List<ListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
        return this;
    }

    public ReplicatedMapConfig addEntryListenerConfig(EntryListenerConfig listenerConfig) {
        this.getListenerConfigs().add(listenerConfig);
        return this;
    }

    public boolean isAsyncFillup() {
        return this.asyncFillup;
    }

    public ReplicatedMapConfig setAsyncFillup(boolean asyncFillup) {
        this.asyncFillup = asyncFillup;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public ReplicatedMapConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public ReplicatedMapConfig setSplitBrainProtectionName(String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return this;
    }

    public MergePolicyConfig getMergePolicyConfig() {
        return this.mergePolicyConfig;
    }

    public ReplicatedMapConfig setMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mergePolicyConfig = Preconditions.checkNotNull(mergePolicyConfig, "mergePolicyConfig cannot be null!");
        return this;
    }

    @Override
    @Nullable
    public String getUserCodeNamespace() {
        return this.userCodeNamespace;
    }

    @Override
    public ReplicatedMapConfig setUserCodeNamespace(@Nullable String userCodeNamespace) {
        this.userCodeNamespace = userCodeNamespace;
        return this;
    }

    public String toString() {
        return "ReplicatedMapConfig{name='" + this.name + "'', inMemoryFormat=" + String.valueOf((Object)this.inMemoryFormat) + "', asyncFillup=" + this.asyncFillup + ", statisticsEnabled=" + this.statisticsEnabled + ", splitBrainProtectionName='" + this.splitBrainProtectionName + "', mergePolicyConfig='" + String.valueOf(this.mergePolicyConfig) + "', userCodeNamespace='" + this.userCodeNamespace + "'}";
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 33;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.inMemoryFormat.name());
        out.writeBoolean(this.asyncFillup);
        out.writeBoolean(this.statisticsEnabled);
        SerializationUtil.writeNullableList(this.listenerConfigs, out);
        out.writeString(this.splitBrainProtectionName);
        out.writeObject(this.mergePolicyConfig);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            out.writeString(this.userCodeNamespace);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.inMemoryFormat = InMemoryFormat.valueOf(in.readString());
        this.asyncFillup = in.readBoolean();
        this.statisticsEnabled = in.readBoolean();
        this.listenerConfigs = SerializationUtil.readNullableList(in);
        this.splitBrainProtectionName = in.readString();
        this.mergePolicyConfig = (MergePolicyConfig)in.readObject();
        if (in.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            this.userCodeNamespace = in.readString();
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplicatedMapConfig)) {
            return false;
        }
        ReplicatedMapConfig that = (ReplicatedMapConfig)o;
        if (this.asyncFillup != that.asyncFillup) {
            return false;
        }
        if (this.statisticsEnabled != that.statisticsEnabled) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (this.inMemoryFormat != that.inMemoryFormat) {
            return false;
        }
        if (!Objects.equals(this.splitBrainProtectionName, that.splitBrainProtectionName)) {
            return false;
        }
        if (!Objects.equals(this.mergePolicyConfig, that.mergePolicyConfig)) {
            return false;
        }
        if (!Objects.equals(this.userCodeNamespace, that.userCodeNamespace)) {
            return false;
        }
        return Objects.equals(this.listenerConfigs, that.listenerConfigs);
    }

    public final int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.inMemoryFormat != null ? this.inMemoryFormat.hashCode() : 0);
        result = 31 * result + (this.asyncFillup ? 1 : 0);
        result = 31 * result + (this.statisticsEnabled ? 1 : 0);
        result = 31 * result + (this.listenerConfigs != null ? this.listenerConfigs.hashCode() : 0);
        result = 31 * result + (this.splitBrainProtectionName != null ? this.splitBrainProtectionName.hashCode() : 0);
        result = 31 * result + (this.mergePolicyConfig != null ? this.mergePolicyConfig.hashCode() : 0);
        result = 31 * result + (this.userCodeNamespace != null ? this.userCodeNamespace.hashCode() : 0);
        return result;
    }
}

