/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.collection;

import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.collection.impl.collection.CollectionContainer;
import com.hazelcast.collection.impl.collection.CollectionContainerCollector;
import com.hazelcast.collection.impl.collection.CollectionEvent;
import com.hazelcast.collection.impl.collection.CollectionItem;
import com.hazelcast.collection.impl.collection.operations.CollectionMergeOperation;
import com.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.txncollection.operations.CollectionTransactionRollbackOperation;
import com.hazelcast.config.CollectionConfig;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.internal.monitor.impl.AbstractLocalCollectionStats;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.partition.MigrationAwareService;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.services.TransactionalService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventPublishingService;
import com.hazelcast.spi.impl.merge.AbstractContainerMerger;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

public abstract class CollectionService
implements ManagedService,
RemoteService,
EventPublishingService<CollectionEvent, ItemListener<Data>>,
TransactionalService,
MigrationAwareService,
SplitBrainProtectionAwareService,
SplitBrainHandlerService {
    protected final NodeEngine nodeEngine;
    protected final SerializationService serializationService;
    protected final IPartitionService partitionService;
    private final ILogger logger;

    protected CollectionService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.serializationService = nodeEngine.getSerializationService();
        this.partitionService = nodeEngine.getPartitionService();
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.getContainerMap().clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public void destroyDistributedObject(String name, boolean local) {
        CollectionContainer container = (CollectionContainer)this.getContainerMap().remove(name);
        if (container != null) {
            container.destroy();
        }
        this.nodeEngine.getEventService().deregisterAllLocalListeners(this.getServiceName(), name);
    }

    public abstract CollectionContainer getOrCreateContainer(String var1, boolean var2);

    public abstract ConcurrentMap<String, ? extends CollectionContainer> getContainerMap();

    public abstract String getServiceName();

    @Override
    public void dispatchEvent(CollectionEvent event, ItemListener<Data> listener) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(event.getCaller());
        DataAwareItemEvent itemEvent = new DataAwareItemEvent(event.getName(), event.getEventType(), event.getData(), member, this.serializationService);
        if (member == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Dropping event " + String.valueOf(itemEvent) + " from unknown address:" + String.valueOf(event.getCaller()));
            }
            return;
        }
        String namespace = this.lookupNamespace(event.getName());
        NamespaceUtil.runWithNamespace(this.nodeEngine, namespace, () -> {
            if (event.getEventType() == ItemEventType.ADDED) {
                listener.itemAdded(itemEvent);
            } else {
                listener.itemRemoved(itemEvent);
            }
        });
    }

    @Override
    public void rollbackTransaction(UUID transactionId) {
        Set collectionNames = this.getContainerMap().keySet();
        OperationService operationService = this.nodeEngine.getOperationService();
        for (String name : collectionNames) {
            int partitionId = this.partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            Operation operation = new CollectionTransactionRollbackOperation(name, transactionId).setPartitionId(partitionId).setService(this).setNodeEngine(this.nodeEngine);
            operationService.invokeOnPartition(operation);
        }
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    protected Map<String, CollectionContainer> getMigrationData(PartitionReplicationEvent event) {
        HashMap<String, CollectionContainer> migrationData = new HashMap<String, CollectionContainer>();
        for (Map.Entry entry : this.getContainerMap().entrySet()) {
            String name = (String)entry.getKey();
            int partitionId = this.partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            CollectionContainer container = (CollectionContainer)entry.getValue();
            if (partitionId != event.getPartitionId() || container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(name, container);
        }
        return migrationData;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearCollectionsHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearCollectionsHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearCollectionsHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        Set entrySet = this.getContainerMap().entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            CollectionContainer container = (CollectionContainer)entry.getValue();
            int containerPartitionId = this.partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            if (containerPartitionId != partitionId || thresholdReplicaIndex >= 0 && thresholdReplicaIndex <= container.getConfig().getTotalBackupCount()) continue;
            container.destroy();
            iterator.remove();
        }
    }

    public void addContainer(String name, CollectionContainer container) {
        this.getRawContainerMap().put(name, container);
    }

    private ConcurrentMap<String, CollectionContainer> getRawContainerMap() {
        return this.getContainerMap();
    }

    @Override
    public Runnable prepareMergeRunnable() {
        CollectionContainerCollector collector = new CollectionContainerCollector(this.nodeEngine, this.getRawContainerMap());
        collector.run();
        return new Merger(collector);
    }

    public abstract AbstractLocalCollectionStats getLocalCollectionStats(String var1);

    public static String lookupNamespace(NodeEngine engine, String serviceName, String setName) {
        if (engine.getNamespaceService().isEnabled()) {
            CollectionService service = (CollectionService)engine.getService(serviceName);
            return service.lookupNamespace(setName);
        }
        return null;
    }

    protected abstract String lookupNamespace(String var1);

    private class Merger
    extends AbstractContainerMerger<CollectionContainer, Collection<Object>, SplitBrainMergeTypes.CollectionMergeTypes<Object>> {
        Merger(CollectionContainerCollector collector) {
            super(collector, CollectionService.this.nodeEngine);
        }

        @Override
        protected String getLabel() {
            return "collection";
        }

        @Override
        public void runInternal() {
            for (Map.Entry entry : this.collector.getCollectedContainers().entrySet()) {
                int partitionId = (Integer)entry.getKey();
                Collection containerList = (Collection)entry.getValue();
                for (CollectionContainer container : containerList) {
                    Collection<CollectionItem> items = container.getCollection();
                    String name = container.getName();
                    CollectionConfig config = container.getConfig();
                    SplitBrainMergePolicy<Collection<Object>, SplitBrainMergeTypes.CollectionMergeTypes<Object>, Collection<Object>> mergePolicy = this.getMergePolicy(config.getMergePolicyConfig(), config.getUserCodeNamespace());
                    SplitBrainMergeTypes.CollectionMergeTypes<Object> mergingValue = MergingValueFactory.createMergingValue(CollectionService.this.serializationService, items);
                    this.sendBatch(partitionId, name, mergePolicy, mergingValue);
                    items.clear();
                }
            }
        }

        private void sendBatch(int partitionId, String name, SplitBrainMergePolicy<Collection<Object>, SplitBrainMergeTypes.CollectionMergeTypes<Object>, Collection<Object>> mergePolicy, SplitBrainMergeTypes.CollectionMergeTypes<Object> mergingValue) {
            CollectionMergeOperation operation = new CollectionMergeOperation(name, mergePolicy, mergingValue);
            this.invoke(CollectionService.this.getServiceName(), operation, partitionId);
        }
    }
}

