/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.RoutingMode;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.proxy.txn.TransactionContextProxy;
import com.hazelcast.client.impl.proxy.txn.xa.XATransactionContextProxy;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.ClientTransactionManagerService;
import com.hazelcast.client.impl.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.transaction.xa.Xid;

public class ClientTransactionManagerServiceImpl
implements ClientTransactionManagerService {
    private final HazelcastClientInstanceImpl client;

    public ClientTransactionManagerServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    public HazelcastClientInstanceImpl getClient() {
        return this.client;
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.newTransactionContext(TransactionOptions.getDefault());
    }

    @Override
    public TransactionContext newTransactionContext(@Nonnull TransactionOptions options) {
        return new TransactionContextProxy(this, options);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.executeTransaction(TransactionOptions.getDefault(), task);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionOptions options, @Nonnull TransactionalTask<T> task) throws TransactionException {
        Preconditions.checkNotNull(options, "TransactionOptions must not be null!");
        Preconditions.checkNotNull(task, "TransactionalTask is required!");
        TransactionContext context = this.newTransactionContext(options);
        context.beginTransaction();
        try {
            T value = task.execute(context);
            context.commitTransaction();
            return value;
        }
        catch (Throwable e) {
            context.rollbackTransaction();
            if (e instanceof TransactionException) {
                TransactionException exception = (TransactionException)e;
                throw exception;
            }
            Throwable throwable = e.getCause();
            if (throwable instanceof TransactionException) {
                TransactionException transactionException = (TransactionException)throwable;
                throw transactionException;
            }
            if (e instanceof RuntimeException) {
                RuntimeException exception = (RuntimeException)e;
                throw exception;
            }
            throw new TransactionException(e);
        }
    }

    @Override
    public TransactionContext newXATransactionContext(Xid xid, int timeoutInSeconds) {
        return new XATransactionContextProxy(this, xid, timeoutInSeconds);
    }

    public void shutdown() {
    }

    @Override
    public String getClusterName() {
        return this.client.getClientConfig().getClusterName();
    }

    public ClientConnection connect() throws Exception {
        ClientInvocationServiceImpl invocationService = (ClientInvocationServiceImpl)this.client.getInvocationService();
        long startTimeMillis = System.currentTimeMillis();
        long invocationTimeoutMillis = invocationService.getInvocationTimeoutMillis();
        while (this.client.getLifecycleService().isRunning()) {
            try {
                ClientConnection connection = this.client.getConnectionManager().getRandomConnection();
                if (connection == null) {
                    throw this.throwException();
                }
                return connection;
            }
            catch (Exception e) {
                if (e instanceof HazelcastClientOfflineException) {
                    throw e;
                }
                if (System.currentTimeMillis() - startTimeMillis > invocationTimeoutMillis) {
                    throw this.newOperationTimeoutException(e, invocationTimeoutMillis, startTimeMillis);
                }
                Thread.sleep(invocationService.getInvocationRetryPauseMillis());
            }
        }
        throw new HazelcastClientNotActiveException();
    }

    private Exception newOperationTimeoutException(Throwable e, long invocationTimeoutMillis, long startTimeMillis) {
        StringBuilder sb = new StringBuilder();
        sb.append("Creating transaction context timed out because exception occurred after client invocation timeout ");
        sb.append(invocationTimeoutMillis).append(" ms. ");
        sb.append("Current time: ").append(StringUtil.timeToString(Clock.currentTimeMillis())).append(". ");
        sb.append("Start time: ").append(StringUtil.timeToString(startTimeMillis)).append(". ");
        sb.append("Total elapsed time: ").append(Clock.currentTimeMillis() - startTimeMillis).append(" ms. ");
        String msg = sb.toString();
        return new OperationTimeoutException(msg, e);
    }

    private RuntimeException throwException() {
        ClientConfig clientConfig = this.client.getClientConfig();
        ClientConnectionStrategyConfig connectionStrategyConfig = clientConfig.getConnectionStrategyConfig();
        ClientConnectionStrategyConfig.ReconnectMode reconnectMode = connectionStrategyConfig.getReconnectMode();
        if (reconnectMode == ClientConnectionStrategyConfig.ReconnectMode.ASYNC) {
            throw new HazelcastClientOfflineException();
        }
        String msg = this.getExceptionMsgByRoutingMode();
        throw new IllegalStateException(msg);
    }

    private String getExceptionMsgByRoutingMode() {
        RoutingMode routingMode = this.client.getConnectionManager().getRoutingMode();
        return switch (routingMode) {
            case RoutingMode.ALL_MEMBERS -> this.toAllMembersModeExceptionMsg();
            case RoutingMode.SINGLE_MEMBER -> "No active connection is found";
            case RoutingMode.MULTI_MEMBER -> this.toMultiMemberModeExceptionMsg();
            default -> throw new IllegalStateException("Unsupported RoutingMode: " + String.valueOf((Object)routingMode));
        };
    }

    private String toAllMembersModeExceptionMsg() {
        Collection<Member> members = this.client.getClientClusterService().getEffectiveMemberList();
        if (members.isEmpty()) {
            return "No address was returned by the LoadBalancer since there are no members in the cluster";
        }
        return "No address was returned by the LoadBalancer. But the cluster contains the following members:" + String.valueOf(members);
    }

    private String toMultiMemberModeExceptionMsg() {
        ClientClusterService clientClusterService = this.client.getClientClusterService();
        Collection<Member> effectiveMembers = clientClusterService.getEffectiveMemberList();
        Collection<Member> allMembers = clientClusterService.getMemberList();
        if (effectiveMembers.isEmpty() && allMembers.isEmpty()) {
            return "No address was returned by the LoadBalancer since there is no member in subset and in the cluster as well";
        }
        if (effectiveMembers.isEmpty()) {
            return "No address was returned by the LoadBalancer since there is no member in subset but the cluster has these members:" + String.valueOf(allMembers);
        }
        return "No address was returned by the LoadBalancer. But the effective members list contains the following:" + String.valueOf(effectiveMembers) + ", while the cluster has these members:" + String.valueOf(allMembers);
    }
}

