/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapEntrySetCodec;
import com.hazelcast.client.impl.protocol.task.map.DefaultMapQueryMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.map.impl.LocalMapStatsUtil;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MapEntrySetMessageTask
extends DefaultMapQueryMessageTask<String> {
    public MapEntrySetMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object reduce(Collection<QueryResultRow> result) {
        ArrayList<QueryResultRow> entries = new ArrayList<QueryResultRow>(result);
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        LocalMapStatsUtil.incrementOtherOperationsCount(mapService, (String)this.parameters);
        this.incrementMapMetric(mapService, (String)this.parameters);
        if (result.size() >= mapService.getMapServiceContext().getExpensiveInvocationReportingThreshold()) {
            this.logger.info("Client " + String.valueOf(this.endpoint.getUuid()) + " invoked entrySet() on map " + (String)this.parameters + " with " + result.size() + " returned entries.");
        }
        return entries;
    }

    @Override
    protected Predicate getPredicate() {
        return Predicates.alwaysTrue();
    }

    @Override
    protected IterationType getIterationType() {
        return IterationType.ENTRY;
    }

    @Override
    protected String decodeClientMessage(ClientMessage clientMessage) {
        return MapEntrySetCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapEntrySetCodec.encodeResponse((List)response);
    }

    @Override
    public String getDistributedObjectName() {
        return (String)this.parameters;
    }

    @Override
    public String getMethodName() {
        return "entrySet";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    private void incrementMapMetric(MapService service, String mapName) {
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        if (mapServiceContext.getMapContainer(mapName).getMapConfig().isStatisticsEnabled()) {
            mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(mapName).incrementEntrySetCallCount();
        }
    }
}

