/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.holder.WanConsumerConfigHolder;
import com.hazelcast.internal.serialization.Data;
import java.util.Map;

public final class WanConsumerConfigHolderCodec {
    private static final int PERSIST_WAN_REPLICATED_DATA_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 1;

    private WanConsumerConfigHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, WanConsumerConfigHolder wanConsumerConfigHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[1]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, wanConsumerConfigHolder.isPersistWanReplicatedData());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, wanConsumerConfigHolder.getClassName(), StringCodec::encode);
        DataCodec.encodeNullable(clientMessage, wanConsumerConfigHolder.getImplementation());
        MapCodec.encode(clientMessage, wanConsumerConfigHolder.getProperties(), StringCodec::encode, DataCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static WanConsumerConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean persistWanReplicatedData = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        String className = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        Data implementation = DataCodec.decodeNullable(iterator);
        Map<String, Data> properties = MapCodec.decode(iterator, StringCodec::decode, DataCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new WanConsumerConfigHolder(persistWanReplicatedData, className, implementation, properties);
    }
}

