/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.custom.VectorPairCodec;
import com.hazelcast.client.impl.protocol.codec.holder.VectorPairHolder;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.vector.SearchResult;
import com.hazelcast.vector.impl.DataSearchResult;
import java.util.List;

public final class VectorSearchResultCodec {
    private static final int SCORE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private VectorSearchResultCodec() {
    }

    public static void encode(ClientMessage clientMessage, SearchResult<Data, Data> vectorSearchResult) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeFloat(initialFrame.content, 0, vectorSearchResult.getScore());
        clientMessage.add(initialFrame);
        DataCodec.encode(clientMessage, vectorSearchResult.getKey());
        DataCodec.encodeNullable(clientMessage, vectorSearchResult.getValue());
        ListMultiFrameCodec.encodeNullable(clientMessage, vectorSearchResult.getVectors(), VectorPairCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static DataSearchResult decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        float score = FixedSizeTypesCodec.decodeFloat(initialFrame.content, 0);
        Data key = DataCodec.decode(iterator);
        Data value = DataCodec.decodeNullable(iterator);
        List<VectorPairHolder> vectors = ListMultiFrameCodec.decodeNullable(iterator, VectorPairCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createVectorSearchResult(key, value, score, vectors);
    }
}

