/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FloatArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.holder.VectorPairHolder;

public final class VectorPairCodec {
    private static final int TYPE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 1;

    private VectorPairCodec() {
    }

    public static void encode(ClientMessage clientMessage, VectorPairHolder vectorPair) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[1]);
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 0, vectorPair.getType());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, vectorPair.getName());
        CodecUtil.encodeNullable(clientMessage, vectorPair.getVector(), FloatArrayCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static VectorPairHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        byte type = FixedSizeTypesCodec.decodeByte(initialFrame.content, 0);
        String name = StringCodec.decode(iterator);
        float[] vector = CodecUtil.decodeNullable(iterator, FloatArrayCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new VectorPairHolder(name, type, vector);
    }
}

