/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.cache.CacheEventType;
import com.hazelcast.config.BitmapIndexOptions;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.config.vector.Metric;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.management.dto.ClientBwListEntryDTO;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.sql.SqlColumnType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class FixedSizeTypesCodec {
    public static final int BYTE_SIZE_IN_BYTES = 1;
    public static final int SHORT_SIZE_IN_BYTES = 2;
    public static final int INT_SIZE_IN_BYTES = 4;
    public static final int LONG_SIZE_IN_BYTES = 8;
    public static final int FLOAT_SIZE_IN_BYTES = 4;
    public static final int DOUBLE_SIZE_IN_BYTES = 8;
    public static final int BOOLEAN_SIZE_IN_BYTES = 1;
    public static final int UUID_SIZE_IN_BYTES = 17;
    public static final int LOCAL_DATE_SIZE_IN_BYTES = 6;
    public static final int LOCAL_TIME_SIZE_IN_BYTES = 7;
    public static final int LOCAL_DATE_TIME_SIZE_IN_BYTES = 13;
    public static final int OFFSET_DATE_TIME_SIZE_IN_BYTES = 17;

    private FixedSizeTypesCodec() {
    }

    public static void encodeInt(byte[] buffer, int pos, int value) {
        Bits.writeIntL(buffer, pos, value);
    }

    public static int decodeInt(byte[] buffer, int pos) {
        return Bits.readIntL(buffer, pos);
    }

    public static void encodeInt(byte[] buffer, int pos, CacheEventType cacheEventType) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, cacheEventType.getType());
    }

    public static void encodeInt(byte[] buffer, int pos, IndexType indexType) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, indexType.getId());
    }

    public static void encodeInt(byte[] buffer, int pos, BitmapIndexOptions.UniqueKeyTransformation uniqueKeyTransformation) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, uniqueKeyTransformation.getId());
    }

    public static void encodeInt(byte[] buffer, int pos, CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, expiryPolicyType.getId());
    }

    public static void encodeInt(byte[] buffer, int pos, ProtocolType protocolType) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, protocolType.getId());
    }

    public static void encodeInt(byte[] buffer, int pos, FieldKind fieldKind) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, fieldKind.getId());
    }

    public static void encodeInt(byte[] buffer, int pos, TimeUnit timeUnit) {
        int timeUnitId = TimeUnit.NANOSECONDS == timeUnit ? 0 : (TimeUnit.MICROSECONDS == timeUnit ? 1 : (TimeUnit.MILLISECONDS == timeUnit ? 2 : (TimeUnit.SECONDS == timeUnit ? 3 : (TimeUnit.MINUTES == timeUnit ? 4 : (TimeUnit.HOURS == timeUnit ? 5 : (TimeUnit.DAYS == timeUnit ? 6 : -1))))));
        FixedSizeTypesCodec.encodeInt(buffer, pos, timeUnitId);
    }

    public static void encodeInt(byte[] buffer, int pos, ClientBwListEntryDTO.Type clientBwListEntryType) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, clientBwListEntryType.getId());
    }

    public static void encodeInt(byte[] buffer, int pos, SqlColumnType columnType) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, columnType.getId());
    }

    public static void encodeInt(byte[] buffer, int pos, MemoryUnit memoryUnit) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, memoryUnit.getId());
    }

    public static void encodeInt(byte[] buffer, int pos, JobStatus jobStatus) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, jobStatus.getId());
    }

    public static void encodeInt(byte[] buffer, int pos, Metric metric) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, metric.getId());
    }

    public static void encodeShort(byte[] buffer, int pos, short value) {
        Bits.writeShortL(buffer, pos, value);
    }

    public static short decodeShort(byte[] buffer, int pos) {
        return Bits.readShortL(buffer, pos);
    }

    public static void encodeLong(byte[] buffer, int pos, long value) {
        Bits.writeLongL(buffer, pos, value);
    }

    public static long decodeLong(byte[] buffer, int pos) {
        return Bits.readLongL(buffer, pos);
    }

    public static void encodeFloat(byte[] buffer, int pos, float value) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, Float.floatToIntBits(value));
    }

    public static float decodeFloat(byte[] buffer, int pos) {
        return Float.intBitsToFloat(FixedSizeTypesCodec.decodeInt(buffer, pos));
    }

    public static void encodeDouble(byte[] buffer, int pos, double value) {
        FixedSizeTypesCodec.encodeLong(buffer, pos, Double.doubleToLongBits(value));
    }

    public static double decodeDouble(byte[] buffer, int pos) {
        return Double.longBitsToDouble(FixedSizeTypesCodec.decodeLong(buffer, pos));
    }

    public static void encodeBoolean(byte[] buffer, int pos, boolean value) {
        buffer[pos] = (byte)(value ? 1 : 0);
    }

    public static boolean decodeBoolean(byte[] buffer, int pos) {
        return buffer[pos] == 1;
    }

    public static void encodeByte(byte[] buffer, int pos, byte value) {
        buffer[pos] = value;
    }

    public static byte decodeByte(byte[] buffer, int pos) {
        return buffer[pos];
    }

    public static void encodeUUID(byte[] buffer, int pos, UUID value) {
        boolean isNull = value == null;
        FixedSizeTypesCodec.encodeBoolean(buffer, pos, isNull);
        if (isNull) {
            return;
        }
        long mostSigBits = value.getMostSignificantBits();
        long leastSigBits = value.getLeastSignificantBits();
        FixedSizeTypesCodec.encodeLong(buffer, pos + 1, mostSigBits);
        FixedSizeTypesCodec.encodeLong(buffer, pos + 1 + 8, leastSigBits);
    }

    public static UUID decodeUUID(byte[] buffer, int pos) {
        boolean isNull = FixedSizeTypesCodec.decodeBoolean(buffer, pos);
        if (isNull) {
            return null;
        }
        long mostSigBits = FixedSizeTypesCodec.decodeLong(buffer, pos + 1);
        long leastSigBits = FixedSizeTypesCodec.decodeLong(buffer, pos + 1 + 8);
        return new UUID(mostSigBits, leastSigBits);
    }

    public static void encodeLocalDate(byte[] buffer, int pos, LocalDate value) {
        FixedSizeTypesCodec.encodeInt(buffer, pos, value.getYear());
        FixedSizeTypesCodec.encodeByte(buffer, pos + 4, (byte)value.getMonthValue());
        FixedSizeTypesCodec.encodeByte(buffer, pos + 4 + 1, (byte)value.getDayOfMonth());
    }

    public static LocalDate decodeLocalDate(byte[] buffer, int pos) {
        int year = FixedSizeTypesCodec.decodeInt(buffer, pos);
        byte month = FixedSizeTypesCodec.decodeByte(buffer, pos + 4);
        byte dayOfMonth = FixedSizeTypesCodec.decodeByte(buffer, pos + 4 + 1);
        return LocalDate.of(year, month, (int)dayOfMonth);
    }

    public static void encodeLocalTime(byte[] buffer, int pos, LocalTime value) {
        FixedSizeTypesCodec.encodeByte(buffer, pos, (byte)value.getHour());
        FixedSizeTypesCodec.encodeByte(buffer, pos + 1, (byte)value.getMinute());
        FixedSizeTypesCodec.encodeByte(buffer, pos + 2, (byte)value.getSecond());
        FixedSizeTypesCodec.encodeInt(buffer, pos + 3, value.getNano());
    }

    public static LocalTime decodeLocalTime(byte[] buffer, int pos) {
        byte hour = FixedSizeTypesCodec.decodeByte(buffer, pos);
        byte minute = FixedSizeTypesCodec.decodeByte(buffer, pos + 1);
        byte second = FixedSizeTypesCodec.decodeByte(buffer, pos + 2);
        int nano = FixedSizeTypesCodec.decodeInt(buffer, pos + 3);
        return LocalTime.of(hour, minute, second, nano);
    }

    public static void encodeLocalDateTime(byte[] buffer, int pos, LocalDateTime value) {
        FixedSizeTypesCodec.encodeLocalDate(buffer, pos, value.toLocalDate());
        FixedSizeTypesCodec.encodeLocalTime(buffer, pos + 6, value.toLocalTime());
    }

    public static LocalDateTime decodeLocalDateTime(byte[] buffer, int pos) {
        LocalDate date = FixedSizeTypesCodec.decodeLocalDate(buffer, pos);
        LocalTime time = FixedSizeTypesCodec.decodeLocalTime(buffer, pos + 6);
        return LocalDateTime.of(date, time);
    }

    public static void encodeOffsetDateTime(byte[] buffer, int pos, OffsetDateTime value) {
        FixedSizeTypesCodec.encodeLocalDateTime(buffer, pos, value.toLocalDateTime());
        FixedSizeTypesCodec.encodeInt(buffer, pos + 13, value.getOffset().getTotalSeconds());
    }

    public static OffsetDateTime decodeOffsetDateTime(byte[] buffer, int pos) {
        LocalDateTime dateTime = FixedSizeTypesCodec.decodeLocalDateTime(buffer, pos);
        int offsetSeconds = FixedSizeTypesCodec.decodeInt(buffer, pos + 13);
        return OffsetDateTime.of(dateTime, ZoneOffset.ofTotalSeconds(offsetSeconds));
    }
}

