/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.SerializationUtil;

public final class DataCodec {
    public static final String PROPERTY_KEEP_NON_CANONICAL_NULL = "hazelcast.serialization.keep.noncanonical.null";
    private static final boolean KEEP_NON_CANONICAL_NULL = Boolean.getBoolean("hazelcast.serialization.keep.noncanonical.null");

    private DataCodec() {
    }

    public static void encode(ClientMessage clientMessage, Data data) {
        if (SerializationUtil.isNullData(data) && !KEEP_NON_CANONICAL_NULL) {
            throw new IllegalArgumentException("Non-null Data field cannot be sent with null value");
        }
        clientMessage.add(new ClientMessage.Frame(data.toByteArray()));
    }

    public static void encodeNullable(ClientMessage clientMessage, Data data) {
        if (data == null || SerializationUtil.isNullData(data) && !KEEP_NON_CANONICAL_NULL) {
            clientMessage.add(ClientMessage.NULL_FRAME.copy());
        } else {
            clientMessage.add(new ClientMessage.Frame(data.toByteArray()));
        }
    }

    public static Data decode(ClientMessage.ForwardFrameIterator iterator) {
        HeapData heapData = new HeapData(iterator.next().content);
        if (SerializationUtil.isNullData(heapData) && !KEEP_NON_CANONICAL_NULL) {
            throw new IllegalArgumentException("Non-null Data field with null value in incoming message");
        }
        return heapData;
    }

    public static Data decodeNullable(ClientMessage.ForwardFrameIterator iterator) {
        if (CodecUtil.nextFrameIsNullEndFrame(iterator)) {
            return null;
        }
        HeapData heapData = new HeapData(iterator.next().content);
        return SerializationUtil.isNullData(heapData) && !KEEP_NON_CANONICAL_NULL ? null : heapData;
    }
}

