/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.internal.serialization.Data;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class CodecUtil {
    private CodecUtil() {
    }

    public static void fastForwardToEndFrame(ClientMessage.ForwardFrameIterator iterator) {
        int numberOfExpectedEndFrames = 1;
        while (numberOfExpectedEndFrames != 0) {
            ClientMessage.Frame frame = iterator.next();
            if (frame.isEndFrame()) {
                --numberOfExpectedEndFrames;
                continue;
            }
            if (!frame.isBeginFrame()) continue;
            ++numberOfExpectedEndFrames;
        }
    }

    public static <T> void encodeNullable(ClientMessage clientMessage, T value, BiConsumer<ClientMessage, T> encode) {
        assert (!(value instanceof Data)) : "For serializing nullable Data specialized codec must be used";
        if (value == null) {
            clientMessage.add(ClientMessage.NULL_FRAME.copy());
        } else {
            encode.accept(clientMessage, (ClientMessage)value);
        }
    }

    public static <T> T decodeNullable(ClientMessage.ForwardFrameIterator iterator, Function<ClientMessage.ForwardFrameIterator, T> decode) {
        T result;
        T t = result = CodecUtil.nextFrameIsNullEndFrame(iterator) ? null : (T)decode.apply(iterator);
        assert (!(result instanceof Data)) : "For deserializing nullable Data specialized codec must be used";
        return result;
    }

    public static boolean nextFrameIsDataStructureEndFrame(ClientMessage.ForwardFrameIterator iterator) {
        return iterator.peekNext().isEndFrame();
    }

    public static boolean nextFrameIsNullEndFrame(ClientMessage.ForwardFrameIterator iterator) {
        boolean isNull = iterator.peekNext().isNullFrame();
        if (isNull) {
            iterator.next();
        }
        return isNull;
    }
}

